-- ------------------------------------------------------------------------------ --
--                                TradeSkillMaster                                --
--                          https://tradeskillmaster.com                          --
--    All Rights Reserved - Detailed license information included with addon.     --
-- ------------------------------------------------------------------------------ --

local TSM = select(2, ...) ---@type TSM
local Locale = TSM.Include("Locale")
if not Locale.ShouldLoad("frFR") then return end
local L = {}

-- LOCALE STRINGS START HERE
L["%d Characters"] = "%d Personnages"
L["%d Custom Sources"] = "%d Sources Personnalisées"
L["%d Faction-Realms"] = "%d Faction-Royaumes"
L["%d Groups"] = "%d Groupes"
L["%d Groups Selected"] = "%d Groupes sélectionnés"
L["%d Guilds"] = "%d Guildes"
L["%d Items"] = "%d Objets"
L["%d Operations"] = "%d Opérations"
L["%d Players"] = "%d Joueurs"
L["%d Professions"] = "%d Métiers"
L["%d Rarities"] = "%d rare"
L["%d Results"] = "%d Résultats"
L["%d Selected"] = "%d Sélectionné(s)"
L["%d Sources"] = "%d Sources"
L["%d Sub-Groups"] = "%d Sous-Groupes"
L["%d Types"] = "%d Types"
L["%d auctions"] = "%d enchères"
L["%d groups"] = "%d groupes"
L["%d groups were created and %d items were added from the table."] = "%d groupes ont été créés et %d éléments ont été ajoutés à partir de la table."
L["%d of %d"] = "%d de %d"
L["%d subgroups included"] = "%d sous-groupes inclus"
L["%d |4Group:Groups; Selected (%d |4Item:Items;)"] = "%d |4Group:Groups; Sélectionné (%d |4Objet:Objets;)"
L["%s %s Operations"] = "%s %s Opérations"
L["%s (%s bags, %s bank, %s AH, %s mail)"] = "%s (%s sacs, %s banque, %s HV, %s courrier)"
L["%s (%s player, %s alts, %s AH)"] = "%s (%s Joueurs, %s rerolls, %s HV)"
L["%s (%s player, %s alts, %s guild, %s AH)"] = "%s (%s joueur, %s rerolls, %s guilde, %s HV)"
L["%s (%s profit)"] = "%s (gain %s)"
L["%s - %s has been reset to default values."] = "%s - %s a été réinitialisé aux valeurs par défaut."
L["%s Crafts"] = "%s Artisanat"
L["%s Items Bought"] = "%s Objets Achetés"
L["%s Items Cancelled"] = "%s Objets Annulés"
L["%s Items Expired"] = "%s Objets Expirés"
L["%s Items Resold"] = "%s Objets Revendus"
L["%s Items Selected"] = "%s Objets Sélectionnés"
L["%s Items Sold"] = "%s Objets Vendus"
L["%s Items Total"] = "%s Total d'Objets"
L["%s Operations"] = "Opérations %s"
L["%s Posted Auctions"] = "%s enchères publiées"
L["%s Posted Auctions (Filtered)"] = "Enchères publiées %s (filtrées)"
L["%s Sold Auctions"] = "Enchères %s vendues"
L["%s Sold Auctions (Filtered)"] = "Enchères %s vendues (filtrées)"
L["%s Total"] = "%s Total"
L["%s Total Profit"] = "%s Bénéfice total"
L["%s ago"] = "depuis %s"
L["%s group is already up to date."] = "Le groupe %s est déjà à jour."
L["%s group updated with %d items and %d materials."] = "Groupe %s mis à jour avec %d objets et %d matériaux."
L["%s in guild vault"] = "%s dans la banque de guilde"
L["%s is a valid custom price but %s is an invalid item."] = "%s est un prix personnalisé valide mais %s est un objet invalide."
L["%s is a valid custom price but did not give a value for %s."] = "%s est un prix personnalisé valide mais ne donne aucune valeur pour %s."
L["%s is not a valid custom price and gave the following error: %s"] = "%s est un prix personnalisé invalide car il affiche cette erreur : %s"
L["%s is not a valid source."] = "%s is not a valid source."
L["%s operation"] = "%s opération"
L["%s operations"] = "Opérations %s"
L["%s previously had the max number of operations, so removed %s."] = "%s avait auparavant le nombre maximal d'opérations, donc supprimé %s."
L["%s removed."] = "%s supprimé."
L["%s sent you %s"] = "%s vous a envoyé %s"
L["%s sent you %s and %s"] = "%s vous a envoyé %s et %s"
L["%s sent you a COD of %s for %s"] = "%s vous a envoyé un courrier C.R. de %s pour %s"
L["%s sent you a message: %s"] = "%s vous a envoyé un message %s"
L["%s total"] = "%s au total"
L["%sDrag%s to move this button"] = "%sDrag%s pour déplacer ce bouton"
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of purchase data has been preserved."] = "%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of purchase data has been preserved."
L["%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of sale data has been preserved."] = "%sIMPORTANT:|r When Accounting data was last saved for this realm, it was too big for WoW to handle, so old data was automatically trimmed in order to avoid corruption of the saved variables. The last %s of sale data has been preserved."
L["%sLeft-Click%s to open the main window"] = "%sClique-gauche%s pour ouvrir la fenêtre principale"
L["%sLeft-Click|r to ignore an item for this session. Hold %sShift|r to ignore permanently. You can remove items from permanent ignore in the Vendoring settings."] = "Cliquez avec %sClique-gauche|r pour ignorer un élément de cette session. Maintenez %sMaj|r pour ignorer définitivement. Vous pouvez supprimer des éléments de l'ignorer permanent dans les paramètres de vente."
L["'%s' is an invalid operation. Min restock of %d is higher than max restock of %d for %s."] = "'%s' est une opération non valide. Le réapprovisionnement minimal de %d est supérieur au réapprovisionnement maximal de %d pour %s."
L["'%s' is not a valid argument for convert()."] = "'%s' is not a valid argument for convert()."
L["'%s' is not a valid item argument."] = "'%s' is not a valid item argument."
L["(%d/500 Characters)"] = "(%d/500 Personnages)"
L["(minimum 0 - maximum %d)"] = "(minimum 0 - maximum %d)"
L["1 Group"] = "1 Groupe"
L["1 Item"] = "1 Objet"
L["1D"] = "1J"
L["1M"] = "1M"
L["1W"] = "1S"
L["1Y"] = "1A"
L["2Y"] = "2A"
L["3M"] = "3M"
L["6M"] = "6M"
L["A custom price of %s for %s evaluates to %s."] = "Un prix personnalisé de %s pour %s évalué à %s."
L["A profile with that name already exists on the target account. Rename it first and try again."] = "Un profil portant ce nom existe déjà sur le compte cible. Renommez-le d'abord et réessayez."
L["A profile with this name already exists."] = "Un profil portant ce nom existe déjà."
L["A scan is already in progress. Please stop that scan before starting another one."] = "Un scan est en cours actuellement. Arrêtez le scan avant d'en démarrer un nouveau."
L["A single craft makes %d and you only need to restock %d."] = "Un métier unique fait %d et vous avez seulement besoin de réapprovisionner %d."
L["AH"] = "HV"
L["AH (Crafting)"] = "HV (Artisanat)"
L["AH (Disenchanting)"] = "HV (Désenchantement)"
L["AH BUSY"] = "HV OCCUPÉ"
L["AHDB Minimum Bid"] = "HVBD - Enchère minimum"
L["AHDB Minimum Buyout"] = "HVBD Rachat minimum"
L["ALT"] = "ALT"
L["Above max expires."] = "Nombre maximal de dépôts atteind"
L["Above max price. Not posting."] = "Au-dessus du prix maximum. Pas d'enchère créée."
L["Above max price. Posting at max."] = "Au-dessus du prix max. Enchère créée au prix max."
L["Above max price. Posting at min."] = "Au-dessus du prix max. Enchère créée au prix min."
L["Above max price. Posting at normal."] = "Au-dessus du prix max. Enchère créée au prix normal."
L["Accept COD?"] = "Accepter le courrier en C.R.?"
L["Accepting this item will cost: %s"] = "Accepter cet objet coûtera : %s"
L["Account Syncing"] = "Synchronisation de compte"
L["Account sync removed. Please delete the account sync from the other account as well."] = "La synchronisation de compte a été supprimée. Supprimez également la synchronisation de compte de l'autre compte."
L["Accounting"] = "Accounting"
L["Active"] = "Active"
L["Active Alt"] = "Active Alt"
L["Activity Type"] = "Type d'activité"
L["Add"] = "Ajouter"
L["Add %d |4Item:Items"] = "Ajoutes %d |4Item:Items"
L["Add %s Operation"] = "Ajouter Opération %s"
L["Add More Operations"] = "Ajouter plus d'opérations"
L["Add Operation"] = "Ajouter opération"
L["Add Subject / Description"] = "Ajouter un sujet / Description"
L["Add a new custom source"] = "Ajouter une nouvelle source personnalisée"
L["Add account"] = "Ajouter un compte"
L["Add operation to groups"] = "Ajouter opération au groupes"
L["Add subject & description (optional)"] = "Ajouter sujet & description (optionnel)"
L["Add to Mail"] = "Ajouter au courrier"
L["Added %s to %s."] = "Ajout de %s à %s."
L["Added '%s' profile which was received from %s."] = "Le profil '%s' ajouté a été reçu de %s."
L["Additional error suppressed"] = "Erreur(s) additionelle(s) supprimée(s)"
L["Adjust how TSM values crafted items when calculating profit."] = "Ajustez la façon dont TSM valorise les objets lors du calcul des bénéfices."
L["Adjust how crafted items are restocked."] = "Ajustez la façon dont les objets fabriqués sont réapprovisionnés."
L["Adjust how items are mailed."] = "Ajuster la façon dont les objets sont envoyés."
L["Adjust some general settings."] = "Ajustez certains paramètres généraux."
L["Adjust the settings below to set how groups attached to this operation will be auctioned."] = "Ajustez les paramètres ci-dessous pour définir le mode de vente aux enchères des groupes liés à cette opération."
L["Adjust the settings below to set how groups attached to this operation will be cancelled."] = "Ajustez les paramètres ci-dessous pour définir le mode d'annulation des groupes liés à cette opération."
L["Adjust the settings below to set how groups attached to this operation will be priced."] = "Ajustez les paramètres ci-dessous pour définir la mise à prix des groupes liés à cette opération."
L["Advanced Item Search"] = "Recherche avancée d'objet"
L["Alarm Clock"] = "Alarme"
L["All"] = "Tout"
L["All Auctions"] = "Toutes les enchères"
L["All Bought"] = "Tout acheté"
L["All Cancelled"] = "Tout annulé"
L["All Characters"] = "Tout les personnages"
L["All Expired"] = "Tout expiré"
L["All Faction-Realms"] = "Toutes faction-royaumes"
L["All Guilds"] = "Toutes guildes"
L["All Item Classes"] = "Toutes les classes d'objets"
L["All Other"] = "Tout les autres"
L["All Players"] = "Tous les joueurs"
L["All Professions"] = "Tous les métiers"
L["All Rarites"] = "Toutes les raretés"
L["All Rarities"] = "Toutes les raretés"
L["All Selected"] = "Tous sélectionner"
L["All Slots"] = "Tous les emplacements"
L["All Sold"] = "Tout vendu"
L["All Sources"] = "Toutes les sources"
L["All Subclasses"] = "Toutes les sous-classes"
L["All Time"] = "Tout le temps"
L["All Types"] = "Tous les types"
L["Allow partial stack"] = "Autoriser la pile partielle"
L["Allows for testing of custom prices"] = "Permet de tester les prix personnalisés"
L["Alt Guild Bank"] = "Banque de guilde du reroll"
L["Alts"] = "Rerolls"
L["Alts AH"] = "HV des rerolls"
L["Amount"] = "Montant"
L["Amount kept in bags"] = "Quantité conservé dans les sacs"
L["Amount of bag space to keep free"] = "Quantité d'emplacement de sac à garder libre"
L["An old TSM addon was found installed. Please remove %s and any other old TSM addons to avoid issues."] = "Un ancien module complémentaire TSM a été trouvé installé. Veuillez supprimer %s et tout autre ancien module complémentaire TSM pour éviter les problèmes."
L["App Not Synced"] = "App non synchronisée"
L["App Synced %s Ago"] = "App synchronisée depuis %s"
L["Appearance"] = "Apparence"
L["Apply operation to group"] = "Appliquer l’opération au groupe"
L["Are you sure you want to clear accounting data older than %d days for the currenet realm?"] = "Are you sure you want to clear accounting data older than %d days for the currenet realm?"
L["Are you sure you want to delete the selected operations?"] = "Voulez-vous vraiment supprimer les opérations sélectionnées?"
L["Are you sure you want to delete this operation?"] = "Êtes-vous sûr de vouloir supprimer cette opération ?"
L["At above max price and not undercut."] = "Au-dessus du prix max et sans sous-enchère."
L["At normal price and not undercut."] = "Au prix normal et sans sous-enchère."
L["Attachments"] = "Pièces jointes"
L["Auction"] = "Enchère"
L["Auction House Cut"] = "Commission de l'hôtel des ventes"
L["Auction House Sounds"] = "Sons de l'hôtel des ventes"
L["Auction Window Close"] = "Fermer la fenêtre d’enchère"
L["Auction Window Open"] = "Ouvrir la fenêtre d’enchère"
L["Auction duration"] = "Durée des enchères"
L["Auction has been bid on."] = "L'offre a été mise aux enchères."
L["Auction sale sound"] = "Son d'une enchère"
L["AuctionDB"] = "AuctionDB"
L["AuctionDB - Historical Price"] = "AuctionDB - Historical Price"
L["AuctionDB - Market Value"] = "AuctionDB - Valeur du marché"
L["AuctionDB - Minimum Buyout"] = "AuctionDB - Rachat minimum"
L["AuctionDB - Recent Value"] = "AuctionDB - Recent Value"
L["AuctionDB - Region Historical Price"] = "AuctionDB - Region Historical Price"
L["AuctionDB - Region Market Value Average"] = "AuctionDB - Region Market Value Average"
L["AuctionDB - Region Sale Average"] = "AuctionDB - Region Sale Average"
L["AuctionDB - Region Sale Rate"] = "AuctionDB - Region Sale Rate"
L["AuctionDB - Region Sold Per Day"] = "AuctionDB - Region Sold Per Day"
L["AuctionDB Realm Data is %s Old"] = "Les données du royaume de AuctionDB datent de %s"
L["AuctionDB Region Data is %s Old"] = "Les données de la région de AuctionDB datent de %s"
L["Auctionator - Auction Value"] = "Auctionator - Valeur de l'enchère"
L["Auctioneer - Appraiser"] = "Auctioneer - Expertise"
L["Auctioneer - Market Value"] = "Auctioneer - Valeur du marché"
L["Auctioneer - Minimum Buyout"] = "Auctioneer - Achat minimum"
L["Auctioning"] = "Mise aux Enchères"
L["Auctioning %s button"] = "Bouton %s de mise aux enchères"
L["Auctioning Details"] = "Détails de la vente aux enchères"
L["Auctioning Log"] = "Historique des enchères"
L["Auctioning Operation"] = "Opération d'enchères"
L["Auctioning operation"] = "Opération de vente aux enchères"
L["Auctioning operations control posting to and canceling from the AH."] = "Les opérations de vente aux enchères contrôlent la mise en vente et l'annulation à partir de l'HV."
L["Auctions"] = "Enchères"
L["Auto Quest Complete"] = "Valider les quêtes automatiquement"
L["Auto-focus browse search input"] = "Auto-focus du champ pour la navigation de la recherche"
L["Average Earned per Day"] = "Moyenne gain par jour"
L["Average Prices:"] = "Prix moyens :"
L["Average Profit per Day"] = "Bénéfice moyen par jour"
L["Average Spent per Day"] = "Dépenses moyennes par jour"
L["Avg Buy Price"] = "Prix d'achat moyen"
L["Avg Profit"] = "Bénéfice moyen"
L["Avg Sell Price"] = "Prix de vente moyen"
L["BUSY"] = "OCCUPÉE"
L["BUY"] = "ACHETER"
L["Back"] = "Retour"
L["Bag"] = "Sac"
L["Bags"] = "Sacs"
L["Bank"] = "Bank"
L["Banking"] = "Banque"
L["Banks"] = "Banques"
L["Base Group"] = "Groupe par défaut"
L["Base Item"] = "Objet de base"
L["Below is a list of all available price sources, along with a brief description of what they represent."] = "Vous trouverez ci-dessous une liste de toutes les sources de prix disponibles, ainsi qu'une brève description de ce qu'elles représentent."
L["Below min price. Posting at max."] = "En dessous du prix minimum. Enchère créée au prix max."
L["Below min price. Posting at min."] = "En dessous du prix minimum. Enchère créée au prix min."
L["Below min price. Posting at normal."] = "En dessous du prix minimum. Enchère créée au prix normal."
L["Below you can ignore this operation on certain characters or realms."] = "Ci-dessous, vous pouvez ignorer cette opération sur certains personnages ou royaumes."
L["Bid %d / %d"] = "Offre %d / %d"
L["Bid (item)"] = "Offre (objet)"
L["Bid (stack)"] = "Offre (pile)"
L["Bid (total)"] = "Offre (total)"
L["Bid / Buyout"] = "Offre / Achat immédiat"
L["Bid Auction"] = "Offres d'enchères"
L["Bid Price"] = "Prix de l'offre"
L["Bid Sniper Paused"] = "Sniper d'enchères en pause"
L["Bid Sniper Running"] = "Sniper d'enchères démarré"
L["Bid percent must be between 0 and 100."] = "Le pourcentage de l'offre doit être compris entre 0 et 100."
L["Bidding Auction"] = "Offre aux enchères"
L["Blacklisted players"] = "Joueurs sur liste noire"
L["Bought"] = "Acheté"
L["Bought %d of %s from %s for %s"] = "A acheté %d de %s à %s pour %s"
L["Bought %sx%d for %s from %s"] = "A acheté %sx%d pour %s à %s"
L["Bound Actions"] = "Actions liées"
L["Browse"] = "Parcourir"
L["Browse / Sniper"] = "Parcourir / Sniper"
L["Buy"] = "Acheter"
L["Buy %d / %d"] = "Acheter %d / %d"
L["Buy %d / %d (Confirming %d / %d)"] = "Acheter %d  / %d (Confirmer %d / %d)"
L["Buy Auction"] = "Acheter aux enchères"
L["Buy Commodity"] = "Acheter des produits"
L["Buy Commodity (%02d)"] = "Buy Commodity (%02d)"
L["Buy Groups"] = "Acheter des groupes"
L["Buy Options"] = "Options d'achat"
L["Buy from AH"] = "Acheter à l'HV"
L["Buy from AH (Crafting)"] = "Acheter à l'HV (Artisanat)"
L["Buy from AH (Disenchant)"] = "Acheter à l'HV (désenchanter)"
L["Buy from Vendor"] = "Acheter auprès du vendeur"
L["Buyback All"] = "Tout les rachats"
L["Buyer/Seller"] = "Acheteur/Vendeur"
L["Buyout"] = "Rachat"
L["Buyout (item)"] = "Acheter (objet)"
L["Buyout (stack)"] = "Rachat (pile)"
L["Buyout (total)"] = "Rachat (total)"
L["Buyout Above Threshold"] = "Buyout Above Threshold"
L["Buyout Price"] = "Prix de rachat"
L["Buyout Sniper Paused"] = "Sniper de rachat en pause"
L["Buyout Sniper Running"] = "Sniper rachat en cours d'exécution"
L["Buyout confirmation alert"] = "Alerte de confirmation de rachat"
L["COD"] = "C.R."
L["CRAFT"] = "CRÉER"
L["CRAFTING"] = "ARTISANAT"
L["CTRL"] = "CTRL"
L["Can't load TSM tooltip while in combat"] = "Ne pas charger l'infobulle TSM pendant le combat"
L["Cancel"] = "Annuler"
L["Cancel %d / %d"] = "Annuler %d / %d"
L["Cancel Auction"] = "Annuler l'enchère"
L["Cancel Scan"] = "Annuler le scan"
L["Cancel auctions with bids"] = "Annuler les enchères avec des offres."
L["Cancel or Post"] = "Annuler ou créer une enchère"
L["Cancel to repost higher"] = "Annuler pour remettre en enchère plus haut"
L["Cancel undercut auctions"] = "Retirer les enchères sous-cotées ? (Undercut)"
L["Canceled information"] = "Information annulée"
L["Canceling"] = "Annulation"
L["Canceling %d / %d"] = "Annulation %d / %d"
L["Canceling %d Auctions..."] = "Annulation des %d enchères ..."
L["Canceling Options"] = "Options d'annulation"
L["Canceling auction you've undercut."] = "Annuler vos propres sous-enchères."
L["Canceling disabled."] = "Annulation désactivée."
L["Canceling to repost at higher price."] = "Annuler pour recréer à un prix plus élevé."
L["Canceling to repost at reset price."] = "Annuler pour recréer au prix initial."
L["Canceling to repost higher."] = "Annuler pour recréer plus haut."
L["Canceling undercut auctions and to repost higher."] = "Annuler les enchères sous-cotées pour les recréer plus haut."
L["Canceling undercut auctions."] = "Retrait d'enchère sous-cotée. (Undercut)"
L["Cancelled"] = "Annulé"
L["Cancelled Since Last Sale"] = "Annulé depuis la dernière vente"
L["Cancelled auction of %sx%d"] = "Annuler la vente aux enchères de %sx%d"
L["Cancelled:"] = "Annulé :"
L["Cannot repair from the guild bank!"] = "Impossible de réparer depuis la banque de guilde!"
L["Cannot use additional filters with /crafting or /disenchant."] = "Impossible d'utiliser des filtres supplémentaires avec /crafting ou /disenchant."
L["Cash Register"] = "Caisse"
L["Changes to the specified profile (i.e. '/tsm profile Default' changes to the 'Default' profile)"] = "Modifications du profil spécifié (c-à-d que '/tsm profile Default' passe au profil 'Default')"
L["Character"] = "Personnage"
L["Chat Tab"] = "Onglet Chat"
L["Cheapest auction below min price."] = "Meilleure enchère en dessous du prix minimum."
L["Clear All"] = "Tout effacer"
L["Clear Data"] = "Effacer les données"
L["Clear Filters"] = "Effacer les filtres"
L["Clear Old Data"] = "Effacer les anciennes données"
L["Clear Old Data?"] = "Effacer les anciennes données?"
L["Click and drag to resize this window."] = "Cliquez et faites glisser pour redimensionner cette fenêtre."
L["Click to hide this item for the current session. Hold shift to hide this item permanently."] = "Cliquez pour masquer cet élément pour la session en cours. Maintenez la touche Maj enfoncée pour masquer définitivement cet élément."
L["Coins (%s)"] = "Pièces (%s)"
L["Combine Partial Stacks"] = "Combiner des piles partielles"
L["Combining..."] = "Compilation...."
L["Confirm"] = "Confirmer"
L["Confirm complete sound"] = "Son de confirmation terminé"
L["Confirmation %s button"] = "Bouton %s de confirmation"
L["Confirming %d / %d"] = "Confirmation de %d / %d"
L["Confirming..."] = "Confirming..."
L["Connected to %s"] = "Connecté à %s"
L["Connecting to %s"] = "Connexion à %s"
L["Contacts"] = "Contacts"
L["Contains auctions above your alert threshold!"] = "Contient des enchères au-dessus de votre seuil d'alerte!"
L["Contains auctions above your material value!"] = "Contains auctions above your material value!"
L["Convert Value (%s)"] = "Convert Value (%s)"
L["Cooldown"] = "Cooldown"
L["Cooldowns"] = "Cooldowns"
L["Copy Letter"] = "Copier le courrier"
L["Cost"] = "Coût"
L["Could not create macro as you already have too many. Delete one of your existing macros and try again."] = "Impossible de créer une macro car vous en avez déjà trop. Supprimez l'une de vos macros existantes et réessayez."
L["Could not find profile '%s'. Possible profiles: '%s'"] = "Profil '%s' introuvable. Profils possibles: '%s'"
L["Could not sell items due to not having free bag space available to split a stack of items."] = "Impossible de vendre des articles en raison du manque d'espace libre dans votre sac pour séparer une pile d'articles."
L["Craft"] = "Créer"
L["Craft (Profitable)"] = "Créer (rentable)"
L["Craft (Unprofitable)"] = "Créer (non rentable)"
L["Craft Next"] = "Création suivante"
L["Craft Value"] = "Valeur de la fabrication"
L["Craft Vellum"] = "Craft Vellum"
L["Crafted Items"] = "Objets fabriqués"
L["Crafter"] = "Artisan"
L["Crafting"] = "Artisanat"
L["Crafting %s button"] = "Bouton %s de création"
L["Crafting Cost"] = "Coût de Fabrication"
L["Crafting Material Cost"] = "Coût du matériel de création"
L["Crafting Mode"] = "Mode création"
L["Crafting UI Improvements"] = "Crafting UI Improvements"
L["Crafting Value"] = "Valeur artisanale"
L["Crafting cost"] = "Coût de fabrication"
L["Crafting operation"] = "Opération de création"
L["Crafting operations control how queuing profession crafts."] = "Les opérations de création contrôlent la façon dont les objets de la file d'attente sont crées."
L["Crafts"] = "Artisanat"
L["Create Groups from Table"] = "Créer des groupes à partir de tableau"
L["Create New"] = "Créer un nouveau"
L["Create New Group"] = "Créer un nouveau groupes"
L["Create New Operation"] = "Créer  une Nouvelle Opération"
L["Create Profession Groups"] = "Créer un groupe de professions"
L["Create macro"] = "Créer macro"
L["Create new profile"] = "Créer un nouveau profile"
L["Current Price"] = "Prix actuel"
L["Custom"] = "Custom"
L["Custom Price"] = "Prix personnalisé"
L["Custom Source"] = "Source personnalisée"
L["Custom Sources"] = "Source personnalisé"
L["Custom Theme"] = "Custom Theme"
L["Custom price name %s already exists."] = "Le nom de prix personnalisé %s existe déjà."
L["Custom price name %s is a reserved word which cannot be used."] = "Le nom de prix personnalisé %s est un mot réservé qui ne peut pas être utilisé."
L["Custom price names can only contain lowercase letters."] = "Les noms de prix personnalisés ne peuvent contenir que des lettres minuscules."
L["Custom source (%s)"] = "Source personnalisée (%s)"
L["Custom sources allow you to create more advanced prices for use throughout the addon. You'll be able to use these new variables in the same way you can use the built-in price sources such as %s and %s."] = "Les sources personnalisées vous permettent de créer des prix plus avancés à utiliser dans tout l'addon. Vous pourrez utiliser ces nouvelles variables de la même manière que vous pouvez utiliser les sources de prix intégrées telles que %s et %s."
L["DAILY PURCHASES"] = "ACHATS QUOTIDIENS"
L["DAILY SALES"] = "VENTES QUOTIDIENNES"
L["Dalaran"] = "Dalaran"
L["Dashboard"] = "Tableau de bord"
L["Default Price"] = "Prix par défaut"
L["Default craft value method"] = "Méthode de valeur artisanale par défaut"
L["Default material cost method"] = "Méthode de coût des matériaux par défaut"
L["Default price configuration"] = "Configuration de prix par défaut"
L["Define what priority Gathering gives certain sources."] = "Définissez la priorité que donne la collecte à certaines sources."
L["Delete %d Operations"] = "Supprimer %d opérations"
L["Delete Group?"] = "Supprimer le groupe?"
L["Delete Operation?"] = "Supprimer l'opération?"
L["Delete Operations"] = "Supprimer des opérations"
L["Delete Operations?"] = "Supprimer les opérations?"
L["Delete Profile?"] = "Supprimer le profile?"
L["Delete Record?"] = "Supprimer l'enregistrement?"
L["Delete the profile"] = "Supprimer le profil"
L["Deleting this group (%s) will also remove any sub-groups attached to this group."] = "La suppression de ce groupe (%s) supprimera également tous les sous-groupes attachés à ce groupe."
L["Deposit"] = "Dépôt"
L["Deposit Cost"] = "Coût du dépôt"
L["Deposit reagents"] = "Dépôt des composants"
L["Deselect All"] = "Tout désélectionner"
L["Destroy Next"] = "Détruire le suivant"
L["Destroy Value"] = "Valeur à la destruction"
L["Destroy value"] = "Valeur à la destruction"
L["Destroy value source"] = "Source de la valeur à la destruction"
L["Destroying"] = "Détruire"
L["Destroying %s button"] = "Bouton %s de destruction"
L["Destroying will ignore %s permanently. You can remove it from the ignored list in the settings."] = "La destruction ignorera %s de façon permanente. Vous pouvez le supprimer de la liste ignorée dans les paramètres."
L["Destroying will ignore %s until you log out."] = "La destruction ignorera %s jusqu'à ce que vous vous déconnectiez."
L["Destroying..."] = "Destruction..."
L["Detailed crafting cost"] = "Coût de fabrication détaillé"
L["Details"] = "Détails"
L["Did not cancel %s because your cancel to repost threshold (%s) is invalid. Check your settings."] = "N'a pas annulé %s car votre seuil d'annulation pour remettre aux enchères (%s) n'est pas valide. Vérifiez vos paramètres."
L["Did not cancel %s because your maximum price (%s) is invalid. Check your settings."] = "N'a pas annulé %s parce que votre prix maximum (%s) est invalide. Vérifiez vos paramètres."
L["Did not cancel %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "N'a pas annulé %s parce que votre prix maximum (%s) est plus bas que votre prix minimum (%s). Vérifiez vos paramètres."
L["Did not cancel %s because your minimum price (%s) is invalid. Check your settings."] = "N'a pas annulé %s parce que votre prix minimum (%s) est invalide. Vérifiez vos paramètres."
L["Did not cancel %s because your normal price (%s) is invalid. Check your settings."] = "N'a pas annulé %s parce que votre prix normal (%s) est invalide. Vérifiez vos paramètres."
L["Did not cancel %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "N'a pas annulé %s parce que votre prix normal (%s) est plus bas que votre prix minimum (%s). Vérifiez vos paramètres."
L["Did not cancel %s because your undercut (%s) is invalid. Check your settings."] = "%s non annulé car votre sous-enchère (%s) est invalide, vérifiez vos paramètres."
L["Did not change prices due to an invalid bid or buyout value."] = "N'a pas modifié les prix en raison d'une enchère ou d'une valeur de rachat incorrecte."
L["Did not post %s because Blizzard didn't provide all necessary information for it. Try again later."] = "N'a pas mis en vente %s parce que Blizzard n'a pas fourni toutes les informations nécessaires pour cela. Réessayer plus tard."
L["Did not post %s because the owner of the lowest auction (%s) is on both the blacklist and whitelist which is not allowed. Adjust your settings to correct this issue."] = "N'a pas mis en vente %s parce que le propriétaire de l'enchère la plus basse (%s) est à la fois sur la liste noire et la liste blanche ce qui n'est pas permis. Ajuster vos paramètres pour corriger cette erreur."
L["Did not post %s because you or one of your alts (%s) is on the blacklist which is not allowed. Remove this character from your blacklist."] = "N'a pas mis en vente %s parce que vous ou un de vos rerolls (%s) est sur la liste noire ce qui n'est pas permis. Retirez ce personnage de votre liste noire."
L["Did not post %s because your keep quantity (%s) is invalid. Check your settings."] = "N'a pas mis en vente %s car votre quantité de conservation (%s) n'est pas valide. Vérifiez vos paramètres."
L["Did not post %s because your max expires (%s) is invalid. Check your settings."] = "N'a pas mis en vente  %s car votre durée maximum (%s) n'est pas valide. Vérifiez vos paramètres."
L["Did not post %s because your maximum price (%s) is invalid. Check your settings."] = "N'a pas mis en vente %s parce que votre prix maximum (%s) est invalide. Vérifiez vos paramètres."
L["Did not post %s because your maximum price (%s) is lower than your minimum price (%s). Check your settings."] = "N'a pas mis en vente %s parce que votre prix maximum (%s) est plus bas que votre prix minimum (%s). Vérifiez vos paramètres."
L["Did not post %s because your minimum price (%s) is invalid. Check your settings."] = "N'a pas mis en vente %s parce que votre prix minimum (%s) est invalide. Vérifiez vos paramètres."
L["Did not post %s because your normal price (%s) is invalid. Check your settings."] = "N'a pas mis en vente %s parce que votre prix normal (%s) est invalide. Vérifiez vos paramètres."
L["Did not post %s because your normal price (%s) is lower than your minimum price (%s). Check your settings."] = "N'a pas mis en vente %s parce que votre prix normal (%s) est plus bas que votre prix minimum (%s). Vérifiez vos paramètres."
L["Did not post %s because your post cap (%s) is invalid. Check your settings."] = "N'a pas mis en vente %s car votre limite de mise en vente (%s) n'est pas valide. Vérifiez vos paramètres."
L["Did not post %s because your stack size (%s) is invalid. Check your settings."] = "N'a pas mis en vente %s car la taille de votre pile (%s) n'est pas valide. Vérifiez vos paramètres."
L["Did not post %s because your undercut (%s) is invalid. Check your settings."] = "%s non placée car votre sous-enchère (%s) est invalide, vérifiez vos paramètres."
L["Disable invalid price warnings"] = "Désactiver les alertes des prix invalides."
L["Disenchant Search"] = "Recherche désenchantement"
L["Disenchant Search Options"] = "Option de la recherche désenchantement"
L["Disenchant Value"] = "Valeur désenchanté"
L["Disenchanting Options"] = "Option de désenchantement"
L["Display total money received in chat"] = "Afficher le montant total reçu dans le chat"
L["Don't Post Items"] = "Ne pas mettre en vente les objets"
L["Don't post after this many expires"] = "Ne pas mettre en vente après l'expiration de ce nombre"
L["Don't prompt to record trades"] = "Ne pas demander d'enregistrer les transactions"
L["Done Canceling"] = "Faire l'annulation"
L["Done Posting"] = "Faire l'inscription"
L["Done Scanning"] = "Faire le scan"
L["Done rebuilding item cache."] = "Reconstruction du cache des objets terminés."
L["Down"] = "Bas"
L["Duplicate the profile"] = "Dupliquer le profil"
L["Duration"] = "Duré"
L["Duskwood"] = "Bois de la Pénombre"
L["EXPENSES"] = "FRAIS"
L["Edit"] = "Éditer"
L["Edit Post"] = "Modifier l’enchère"
L["Embed TSM tooltip"] = "Intégrer l'info-bulle TSM"
L["Empty bags"] = "Sacs vides"
L["Empty price string."] = "Chaine de prix vide."
L["Enable TSM tooltips"] = "Activer les info-bulles TSM"
L["Enable automatic stack combination"] = "Activer la combinaison automatique des piles"
L["Enable buying"] = "Activer l'achat"
L["Enable inbox chat messages"] = "Activer les messages de discussion dans la boîte de réception"
L["Enable region-wide trading (requires reload)"] = "Enable region-wide trading (requires reload)"
L["Enable restock"] = "Activer le réapprovisionnement"
L["Enable selling"] = "Activer la vente"
L["Enable sending chat messages"] = "Activer l'envoi de messages de discussion"
L["Enchant"] = "Enchanter"
L["Ensure both characters are online and try again."] = "Assurez vous que les deux personnages connectés et réessayez"
L["Enter Filter"] = "Entrer un filtre"
L["Enter Keyword"] = "Entrer un mot-clé"
L["Enter a value from %d - %d"] = "Entrez une valeur comprise entre %d et %d"
L["Enter a value from %d - %d%%"] = "Entrez une valeur comprise entre %d et %d%%"
L["Enter name of logged-in character on other account"] = "Entrez le nom du personnage connecté sur un autre compte"
L["Enter player name"] = "Entrer le nom d'un joueur"
L["Enter profile name"] = "Entrez le nom du profil"
L["Enter recipient name"] = "Entrez le nom du destinataire"
L["Establishing connection to %s. Make sure that you've entered this character's name on the other account."] = "Connexion en cours avec %s. Assurez-vous d'avoir bien entré le nom de ce personnage sur l'autre compte."
L["Establishing connection..."] = "Connexion en cours..."
L["Estimated Profit"] = "Estimated Profit"
L["Estimated Time"] = "Estimated Time"
L["Estimated deliver time"] = "Temps de livraison estimé"
L["Exact Match"] = "Correspondance exacte"
L["Example"] = "Exemple"
L["Example Item"] = "Exemple d'objet"
L["Example Tooltip"] = "Exemple d'info-bulle"
L["Exclude custom sources?"] = "Exclure les sources personnalisées?"
L["Exclude operations?"] = "Exclure les opérations?"
L["Exit"] = "Quitter"
L["Expand / Collapse All Groups"] = "Développer / Réduire tous les groupes"
L["Expenses"] = "Frais"
L["Expirations"] = "Expirations"
L["Expired"] = "Expiré"
L["Expired Auctions"] = "Enchères expirées"
L["Expired Since Last Sale"] = "Expiré depuis la dernière vente"
L["Expired information"] = "Informations expirées"
L["Expires"] = "Expire"
L["Expires Since Last Sale"] = "Expiré depuis la dernière vente."
L["Expiring Mails"] = "Courriers expirés"
L["Exploration"] = "Exploration"
L["Export"] = "Export"
L["Export Custom Theme"] = "Export Custom Theme"
L["Export String"] = "Exporter la chaîne"
L["Export theme"] = "Export theme"
L["Export this group"] = "Exporter ce groupe"
L["Failed Auctions"] = "Enchères échouées"
L["Failed to bid on auction of %s (x%s) for %s."] = "Échec de l'offre sur l'enchère de %s (x%s) pour %s."
L["Failed to bid on auction of %s."] = "Échec de l'offre sur l'enchère de %s."
L["Failed to buy auction of %s (x%s) for %s."] = "Échec d'achat de l'enchère de %s (x%s) pour %s."
L["Failed to buy auction of %s."] = "Échec de l'achat de l'enchère de %s."
L["Failed to buy auction."] = "Échec de l'achat aux enchères."
L["Failed to cancel auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "Échec de l'annulation des enchères en raison de l'occupation de l’hôtel de vente Assurez-vous qu'aucun autre module complémentaire ne scanne l'HV et réessayez."
L["Failed to find auction for %s, so removing it from the results."] = "Échec de la recherche de l'enchère pour %s, donc le retirer des résultats."
L["Failed to move group, as a group with the same name already exists in the target location."] = "Failed to move group, as a group with the same name already exists in the target location."
L["Failed to post %sx%d as the item no longer exists in your bags."] = "A échoué à poster %sx%d puisque l'objet n'existe plus dans vos sacs."
L["Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."] = "Failed to post auction due to the auction house being busy. Ensure no other addons are scanning the AH and try again."
L["Failed to send profile."] = "Échec d'envoi du profile."
L["Failed to send profile. Ensure both characters are online and try again."] = "Échec d'envoi du profil. Assurez vous que les deux personnages sont connectés et réessayez."
L["Failed to start sniper. No groups have a Sniper operation applied."] = "Échec du démarrage de Sniper. Aucun groupe n'a d'opération Sniper."
L["Favorite Scans"] = "Scans favoris"
L["Favorite Searches"] = "Recherches favorites"
L["Favorited Patterns"] = "Modèles favoris"
L["Filter by Keyword"] = "Filtrer par mot-clé"
L["Filter by Price Source"] = "Filtrer par source de prix"
L["Filter by Profession"] = "Filtrer par métier"
L["Filter by duration"] = "Filtrer par durée"
L["Filter by groups"] = "Filtrer par groupes"
L["Filter by keyword"] = "Filtrer par mot-clé"
L["Filter group item lists based on the following price source"] = "Filtrer les listes d'articles du groupe en fonction de la source de prix suivante"
L["Finding Selected Auction"] = "Trouver l'enchère sélectionnée"
L["First Auctioning Operation Max Price"] = "Prix maximum de la première mise aux enchères"
L["First Auctioning Operation Min Price"] = "Prix minimum de la première mise aux enchères"
L["First Auctioning Operation Normal Price"] = "Prix normal de la première mise aux enchères"
L["Fishing Reel In"] = "Moulinet de pêche dans"
L["For more info, visit %s. For help, join us in Discord: %s."] = "Pour plus d'informations, visitez %s. Pour obtenir de l'aide, rejoignez-nous dans Discord : %s."
L["Forget Character"] = "Oublier le personnage"
L["Found auction sound"] = "Trouver le son d'enchère"
L["Frame"] = "Frame"
L["Friends"] = "Amis"
L["From"] = "De"
L["Full convert tooltip"] = "Full convert tooltip"
L["Full destroy tooltip"] = "Full destroy tooltip"
L["Full inventory"] = "Inventaire complet"
L["GVault"] = "BanqueDeGuilde"
L["Garrison"] = "Garnison"
L["Gathering"] = "Récolte"
L["Gathering Search"] = "Recherche de récolte"
L["Gathering Setup"] = "Configuration de récolte"
L["General Options"] = "Options générales"
L["General Settings"] = "Réglages généraux"
L["Get from Bank"] = "Obtenir de la banque"
L["Get from Guild Bank"] = "Obtenir de la banque de guilde"
L["Gets items from the bank or guild bank matching the item or partial text entered."] = "Obtient les objets de la banque ou de la banque de guilde qui correspond à l'objet ou au texte partiel saisi."
L["Gold"] = "Or"
L["Great Deals Search"] = "Recherche d'offres exceptionnelles"
L["Group Management"] = "Gestion des groupes"
L["Group Search"] = "Recherche groupe"
L["Group already exists."] = "Le groupe existe déjà."
L["Group name"] = "Nom du groupe"
L["Grouped Items"] = "Objets groupés"
L["Grouping Pets by Level"] = "Grouping Pets by Level"
L["Groups"] = "Groupes"
L["Groups & Operations"] = "Groupes & opérations"
L["Groups Using"] = "Groupes utilisés"
L["Guild"] = "Guilde"
L["Guild Bank"] = "Banque de guilde"
L["HIGH"] = "HAUT"
L["Have"] = "Avoir"
L["Have Mats"] = "Comp. disponibles"
L["Have Skill Ups"] = "Peut faire progresser"
L["Here you can add/remove what groups this operation is attached to."] = "Ici, vous pouvez ajouter/supprimer les groupes auxquels cette opération est attachée."
L["Hide Columns"] = "Cacher colonnes"
L["Hide auctions with bids"] = "Masquer les enchères avec des offres"
L["Hide minimap icon"] = "Cacher l'icône de la mini-carte"
L["Hiding the TSM Banking UI. Type '/tsm bankui' to reopen it."] = "Masquer l'interface utilisateur de TSM Bancaire. Tapez  '/tsm bankui' pour la rouvrir."
L["Hiding the TSM Task List UI. Type '/tsm tasklist' to reopen it."] = "Masquer l'interface utilisateur de la liste e tâches TSM. Tapez '/tsm tasklist' pour la rouvrir."
L["High Bidder"] = "Meilleur offre"
L["Historical Price"] = "Historique des prix"
L["Historical price"] = "Historique des prix"
L["Hold ALT to repair from the guild bank."] = "Maintenir ALT pour réparer à partir d'une banque de guilde."
L["Hold SHIFT to automatically resend items after '%s', and CTRL to perform a dry-run where no items are actually mailed, but chat messages will still display the result."] = "Maintenez la touche MAJ enfoncée pour renvoyer automatiquement les éléments après '%s' et CTRL pour effectuer un test à blanc où aucun élément n'est pas réellement envoyé par courrier, mais les messages de discussion afficheront le résultat."
L["Hold SHIFT to continue after the inbox refreshes"] = "Maintenez la touche MAJ enfoncée pour continuer après l'actualisation de la boîte aux lettres"
L["Hold SHIFT to continue after the inbox refreshes and CTRL to not open mail with money attached."] = "Maintenez la touche MAJ pour continuer après l'actualisation de la boîte aux lettres et CTRL pour ne pas ouvrir le courrier avec de l'argent en pièce jointe."
L["Hold SHIFT to not continue after the inbox refreshes"] = "Maintenez la touche MAJ enfoncée pour ne pas continuer après l'actualisation de la boîte aux lettres"
L["Hold SHIFT to not continue after the inbox refreshes and CTRL to not open mail with money attached."] = "Maintenez la touche MAJ pour ne pas continuer après l'actualisation de la boîte aux lettres et CTRL pour ne pas ouvrir le courrier avec de l'argent en pièce jointe."
L["Hold SHIFT while dragging to scale the window instead."] = "Maintenez la touche MAJ tout en faisant glisser pour mettre à l'échelle la fenêtre à la place."
L["Hold shift to move the items to the parent group instead of removing them."] = "Maintenir la touche MAJ pour déplacer les objets dans le groupe parent au lieu de les supprimer."
L["Hr"] = "Hr"
L["Hrs"] = "Hrs"
L["If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."] = "If enabled, TSM will load data (i.e. inventory / Accounting / gold tracking) from every realm you have characters on, instead of just connected realms."
L["If you have multiple profiles set up with operations, enabling this will cause all but the current profile's operations to be irreversibly lost."] = "Si vous avez plusieurs profils configurés avec des opérations, l'activation de cette option entraînera la perte irréversible de toutes les opérations du profil actuel, sauf celles du profil actuel."
L["Ignore Auctions Below Min"] = "Ignorer les enchères sous le minimum"
L["Ignore Characters"] = "Ignorer les personnages"
L["Ignore Guilds"] = "Ignorer les guildes"
L["Ignore auctions by duration"] = "Ignorer les enchères par durée"
L["Ignore operation on characters"] = "Ignorer l'opération sur les personnages"
L["Ignore operation on faction-realms"] = "Ignorer les opérations sur les royaumes/faction"
L["Ignored Cooldowns"] = "Temps de recharge ignorés"
L["Ignored Items"] = "Objets ignorés"
L["Import"] = "Importer"
L["Import Groups & Operations"] = "Importer Groupes & Opérations"
L["Import String"] = "importer chaine de caractère"
L["Import Summary"] = "Résumé de l'importation"
L["Import Theme"] = "Import Theme"
L["Import group"] = "Importer groupe"
L["Imported Group"] = "Groupe importé"
L["Imported group (%s) with %d items, %d operations, and %d custom sources."] = "Groupe importé (%s) avec %d éléments,%d opérations et %d sources personnalisées."
L["In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."] = "In retail, there's a new option in the settings to get TSM to make inventory and accounting data available from every realm in your region."
L["Inbox Settings"] = "Paramètres de boite aux lettres"
L["Include operations?"] = "Inclure les opérations ?"
L["Include soulbound items"] = "Inclure objets liés"
L["Information"] = "Information"
L["Invalid Quantity"] = "Quantité invalide"
L["Invalid custom price source for %s. %s"] = "La source du prix personnalisable pour %s n'est pas valide. %s"
L["Invalid custom price."] = "Prix spécifique invalide."
L["Invalid group name."] = "Nom de groupe invalide."
L["Invalid numeric value."] = "Valeur numérique non valide."
L["Invalid operation name."] = "Nom d'opération invalide."
L["Invalid player name."] = "Nom de joueur invalide."
L["Invalid price."] = "Prix invalide."
L["Invalid search filter (%s)."] = "Filtre de recherche non valide (%s)."
L["Invalid search term."] = "Terme de recherche non valide."
L["Invalid search term. Cannot filter by price here."] = "Terme de recherche non valide. Impossible de filtrer par prix ici."
L["Invalid seller data returned by server."] = "Données de vendeur non valides renvoyées par le serveur."
L["Invalid undercut. To post below the cheapest auction without a significant undercut, set your undercut to 0c."] = "Sous-enchère invalide. Pour mettre en enchère en dessous de la moins chère sans différence de prix, définissez votre 'sous-enchère' sur 0c."
L["Inventory"] = "Inventaire"
L["Inventory / Gold Graph"] = "Inventaire / Courbe des richessses"
L["Inventory Options"] = "Options de l'inventaire"
L["It appears that you've manually copied your saved variables between accounts which will cause TSM's automatic sync'ing to not work. You'll need to undo this, and/or delete the TradeSkillMaster saved variables files on both accounts (with WoW closed) in order to fix this."] = "Il semble que vous ayez copié manuellement vos données enregistrées entre les comptes, ce qui empêchera la synchronisation automatique de TSM. Vous devrez restaurer le dossier  et/ou supprimer les fichiers du répertoire \"saved variables\" de TradeSkillMaster sur les deux comptes (avec WoW fermé) afin de résoudre ce problème."
L["Item"] = "Objet"
L["Item Class"] = "Classe de l'objet"
L["Item Level"] = "Niveau de l'objet"
L["Item Level Range"] = "Gamme de niveau d'objet"
L["Item Name"] = "Nom de l'objet"
L["Item Quality"] = "Qualité de l'objet"
L["Item Selection"] = "Sélection d'objet"
L["Item Slot"] = "Emplacement d'objet"
L["Item Subclass"] = "Sous-classe d'objet"
L["Item Value"] = "Prix de l'objet"
L["Item/Group is invalid (see chat)."] = "L'objet/groupe est invalide (voir l'onglet chat)."
L["Items"] = "Objets"
L["Items Using"] = "objets utilisant"
L["Keep in bags quantity"] = "Conserver en quantité dans les sacs"
L["Keep in bank quantity"] = "Conserver en quantité dans la banque"
L["Keep quantity"] = "Conserver en quantité"
L["Keep this amount"] = "Gardez ce montant"
L["Keeping %d."] = "Conserver %d."
L["Keeping undercut auctions posted."] = "Conserve le prix actuel, même si concurrencé."
L["LEAST GROUPS"] = "MOINS DE GROUPES"
L["LEAST ITEMS"] = "MOINS D'OBJETS"
L["LOW"] = "BAS"
L["Last 14 Days"] = "14 derniers jours"
L["Last 3 Days"] = "3 derniers jours"
L["Last 30 Days"] = "30 derniers jours"
L["Last 60 Days"] = "60 derniers jours"
L["Last 7 Days"] = "7 derniers jours"
L["Last Purchased"] = "Dernier acheté"
L["Last Sold"] = "Dernier vendu"
L["Ledger"] = "Registre"
L["Level Up"] = "Niveau supérieur"
L["Limit"] = "Limite"
L["Link to Another Operation"] = "Lien vers une autre opération"
L["Lock Column Width"] = "Verrouiller la largeur de la colonne"
L["Lock task list's background"] = "Verrouiller la liste des tâches en l'arrière-plan"
L["Looks like TradeSkillMaster has encountered an error. Please help the author fix this error by following the instructions shown."] = "Il semblerait que TradeSkillMaster ai rencontré une erreur. Merci d'aider les développeurs à la corriger en suivant les instructions affichées."
L["Loop detected in the following custom price:"] = "Boucle détectée pour le prix spécifique suivant :"
L["Lowest auction by whitelisted player."] = "Enchère la plus basse par joueur en liste blanche."
L["MAX"] = "MAX"
L["MOST GROUPS"] = "LA PLUPART DES GROUPES"
L["MOST ITEMS"] = "LA PLUPART DES OBJETS"
L["MOVE"] = "DÉPLACER"
L["MOVING"] = "EN DÉPLACEMENT"
L["Macro Setup"] = "Configuration de la Macro"
L["Macro created and scroll wheel bound!"] = "Macro créée et associée à la molette de la souris !"
L["Macros"] = "Macros"
L["Mail"] = "Courrier"
L["Mail Disenchantables"] = "Envoyer les objets désenchantables"
L["Mail Selected Groups"] = "Envoyer les Groupes Sélectionnés"
L["Mail Selected Groups (Auto Resend)"] = "Envoyer les Groupes Sélectionnés (renvoi automatique)"
L["Mail Selected Groups (Dry Run + Auto Resend)"] = "Envoyer les Groupes Sélectionnés (Test à blanc + Renvoi automatique)"
L["Mail Selected Groups (Dry Run)"] = "Envoyer les Groupes Sélectionnés (Test à blanc)"
L["Mail disenchantables max quality"] = "Qualité maximum des objets désenchantables à envoyer"
L["Mail to %s"] = "Envoi à %s"
L["Mailing"] = "Envoi"
L["Mailing all to %s."] = "Envoi de tout à %s."
L["Mailing operation"] = "Opération d'envoi"
L["Mailing operations control mailing to other characters."] = "Les opérations d'envoi contrôlent les courriers envoyé aux autres personnages."
L["Mailing up to %d to %s."] = "Envoi de %d à %s."
L["Make Cash On Delivery?"] = "Envoi en contre-remboursement ?"
L["Make Operations Global?"] = "Rendre les opérations globales?"
L["Management Options"] = "Options de gestion"
L["Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."] = "Many UI improvements have been made to the Dragonflight crafting experience, including support for mass milling / prospecting and easier quality and optional material selection."
L["Many commonly-used actions in TSM can be added to a macro and bound to your scroll wheel. Use the options below to setup this macro and scroll wheel binding."] = "Un grand nombre d'actions usuelles de TSM peuvent être ajoutées à une macro et associées à la molette de la souris. Utilisez les options ci-dessous pour paramétrer cette fonction."
L["Map Ping"] = "Ping sur la carte"
L["Market Value"] = "Valeur du marché"
L["Market Value Price Source"] = "Source du prix de la valeur du marché"
L["Market value"] = "Valeur du marché"
L["Market value and trend"] = "Market value and trend"
L["Market value price source"] = "Source du prix de la valeur du marché"
L["Mat Price"] = "Prix des matières premières"
L["Mat cost"] = "Coût du composant"
L["Match stack size"] = "Faire correspondre la taille de la pile"
L["Match whitelisted players"] = "Faire correspondre aux joueurs de la liste blanche"
L["Material Cost"] = "Coût matériel"
L["Materials"] = "Ingrédients"
L["Materials to Gather"] = "Ingrédients à rassembler"
L["Max"] = "Max"
L["Max Buy Price"] = "Prix d'achat max"
L["Max Price"] = "Prix max"
L["Max Sell Price"] = "Prix de vente max"
L["Max Shopping Price"] = "Prix d'achat max"
L["Max destroy value (Enter '0c' to disable)"] = "Valeur maximale de destruction (entrez '0c' pour désactiver)"
L["Max expires to bank"] = "Expiration max à la banque"
L["Max market value (Enter '0c' to disable)"] = "Valeur du marché maximale (entrez «0c» pour désactiver)"
L["Max quantity"] = "Quantité max"
L["Max shopping price"] = "Prix d'achat max"
L["Max sniper price"] = "Prix Sniper max"
L["Maximum Quantity to Buy"] = "Quantité maximale à acheter"
L["Maximum amount already posted."] = "Quantité maximale déjà postée."
L["Maximum auction price"] = "Prix d'enchère maximum"
L["Maximum disenchant level"] = "Niveau de désenchantement maximum"
L["Maximum disenchant quality"] = "Qualité de désenchantement maximale"
L["Maximum disenchant search percent"] = "Pourcentage maximum de recherche de désenchantement"
L["Maximum price"] = "Prix maximum"
L["Maximum restock quantity"] = "Quantité maximale à réapprovisionner"
L["Midnight"] = "Minuit"
L["Mill"] = "Mill"
L["Mill Value"] = "Valeur de broyage"
L["Min"] = "Min"
L["Min 0 - Max 20"] = "Min 0 - Max 20"
L["Min 0.5 - Max 10"] = "Min 0.5 - Max 10"
L["Min Buy Price"] = "Prix d'achat min"
L["Min Buyout"] = "Prix de rachat min"
L["Min Sell Price"] = "Prix de vente min"
L["Min buyout"] = "Prix de rachat min"
L["Min number of expires"] = "Nombre minimum d'expirations"
L["Min profit amount"] = "Montant du profit minimum"
L["Min/Normal/Max Prices"] = "Prix Min/Normal/Max"
L["Min/Normal/Max price"] = "Prix min/normal/max"
L["Minimum Rarity"] = "Rareté minimale"
L["Minimum disenchant level"] = "Niveau de désenchantement minimum"
L["Minimum price"] = "Prix minimum"
L["Minimum restock quantity"] = "Minimum restock quantity"
L["Missing Materials"] = "Matériaux manquants"
L["Modifiers"] = "Modificateurs"
L["Money Frame Open"] = "Cadre d'argent ouvert"
L["Money Transfer"] = "Transfert d'argent"
L["Move %d already grouped items?"] = "Déplacer %d objets déjà groupés?"
L["Move %d |4Item:Items"] = "Déplacer %d |4Item:Items"
L["Move Item"] = "Déplacer objet"
L["Move Quantity Options"] = "Options de déplacement de quantité"
L["Move all to Bags"] = "Tous déplacer dans les sacs"
L["Move to Parent Group"] = "Déplacer vers le groupe parent"
L["Move to bags"] = "Déplacer dans les sacs"
L["Move to bank"] = "Déplacer dans la banque"
L["Moving"] = "En déplacement"
L["Multiple Items"] = "Plusieurs objets"
L["Must be between %d and %s."] = "Doit être compris entre %d et%s."
L["My Auctions"] = "Mes Enchères"
L["My Auctions %s button"] = "Bouton %s mes enchères"
L["NEED MATS"] = "BESOIN DE COMPOSANTS"
L["NO ITEMS"] = "AUCUN OBJETS"
L["NOT OPEN"] = "FERMÉ"
L["NOTE: The import contained %d invalid items which were ignored."] = "REMARQUE: l'importation contenait %d objet non valides qui ont été ignorés."
L["NOTE: The import contained %d operations with at least one invalid setting which was reset."] = "REMARQUE: l'importation contenait %d opérations avec au moins un paramètre non valide qui a été réinitialisé."
L["NPC"] = "PNJ"
L["Name"] = "Nom"
L["New Group"] = "Nouveau groupe"
L["New Operation"] = "Nouvelle opération"
L["News & Information"] = "Actualité & information"
L["No Attachments"] = "Aucune pièce jointe"
L["No AuctionDB Realm Data"] = "Aucune donnée AuctionDB pour le royaume"
L["No AuctionDB Region Data"] = "Pas de données AuctionDB pour la région"
L["No Characters"] = "Pas de personnage"
L["No Faction-Realms"] = "Pas de faction/royaume"
L["No Guilds"] = "Pas de guilde"
L["No Materials to Gather"] = "Pas de matériaux à rassembler"
L["No Operation Selected"] = "Aucune opération sélectionnée"
L["No Players"] = "Pas de joueur"
L["No Profession Opened"] = "Aucun métier ouvert"
L["No Professions"] = "Pas de métier"
L["No Rarities"] = "Aucune rareté"
L["No Sound"] = "Pas de son"
L["No Sources"] = "Pas de source"
L["No Types"] = "Pas de type"
L["No group selected"] = "Aucun groupe sélectionné"
L["No item specified. Usage: /tsm restock_help [ITEM_LINK]"] = "Aucun objet spécifié. Usage : /tsm restock_help [LIEN_OBJET]"
L["No posting."] = "Pas d'enchère."
L["No profile specified. Possible profiles: '%s'"] = "Aucun profil spécifié. Profils possibles : '%s'"
L["No recent AuctionDB scan data found."] = "Pas d'analyse AuctionDB récent trouvé."
L["No recipe selected"] = "No recipe selected"
L["No value was returned by the custom price for the specified item."] = "Aucune valeur n'a été renvoyée par le prix personnalisé de l'objet spécifié."
L["No, cancel"] = "No, cancel"
L["None"] = "Rien"
L["None (Always Show)"] = "Aucun (toujours afficher)"
L["None Selected"] = "Aucune sélection"
L["Nongroup to bank"] = "Pas de groupe à la banque"
L["Normal price"] = "Prix normal"
L["Not Connected"] = "Non connecté"
L["Not Enough Money"] = "Pas assez d'argent"
L["Not Scanned"] = "Non scanné"
L["Not canceling auction at reset price."] = "Ne pas annuler les enchères sous le prix de réinitialisation."
L["Not canceling auction below min price."] = "Ne pas annuler les enchères sous le prix minimal."
L["Not canceling."] = "Ne pas annuler."
L["Not enough items in bags."] = "Pas assez d'objets dans les sacs."
L["Not enough money to cancel."] = "Pas assez d'argent pour annuler."
L["Nothing to move."] = "Rien à déplacer."
L["Nothing to send."] = "Rien à envoyer."
L["Number Owned"] = "Nombre possédé"
L["Number of days"] = "Number of days"
L["OPEN"] = "OUVERT"
L["Offline"] = "Hors ligne"
L["On Cooldown for %s"] = "On Cooldown for %s"
L["Only show craftable"] = "Appris uniquement"
L["Only show items with disenchant values above this price"] = "Afficher uniquement les articles dont les valeurs de désenchantement sont supérieures à ce prix"
L["Only show sold auctions"] = "Afficher uniquement les enchères vendues"
L["Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."] = "Only the last 6 months of Accounting purchases and sales data for %s was loaded. Consider clearing old Accounting data from the TSM settings on that realm."
L["Open All Mail"] = "Ouvrir tous les courriers"
L["Open All Mail Without Money"] = "Ouvrir tout les courriers sans argent"
L["Open Mail"] = "Ouvrir le courrier"
L["Open Mail Without Money"] = "Ouvrir le courrier sans argent"
L["Open Task List"] = "Ouvrir liste des tâches"
L["Open mail complete sound"] = "Son d'ouverture de courrier terminé"
L["Opens the Destroying frame if there's stuff in your bags to be destroyed."] = "Ouvre la fenêtre de destruction s'il y a des choses dans vos sacs à détruire."
L["Operation"] = "Opération"
L["Operations"] = "Opérations"
L["Options specific to Sniper are below."] = "Les options spécifiques à Sniper sont ci-dessous."
L["Order Confirmation"] = "Confirmation de commande"
L["Orgrimmar"] = "Orgrimmar"
L["Oribos Exchange Realm Price"] = "Oribos Exchange Realm Price"
L["Oribos Exchange Region Price"] = "Oribos Exchange Region Price"
L["Other"] = "Autre"
L["Other Character"] = "Autre personnage"
L["Override Parent Operations"] = "Remplacer les opérations parentes"
L["Override default craft value"] = "Remplacer la valeur d'artisanat par défaut"
L["PROFIT"] = "BÉNÉFICE"
L["Parent Items"] = "Objets parent"
L["Pausing Scan..."] = "Scan en pause ...."
L["Per Item"] = "Par objet"
L["Per Stack"] = "Par pile"
L["Performing a dry-run of your Mailing operations for the selected groups."] = "Effectuer un test à blanc de vos opérations d'envoi postal pour les groupes sélectionnés."
L["Player Gold"] = "Or du joueur"
L["Player Invite Accept"] = "Accepter l'invitation d'autres joueurs"
L["Post"] = "Mise en vente"
L["Post / Cancel"] = "Mise en vente / Annuler"
L["Post Auction"] = "Mettre en vente l’enchère"
L["Post Items from Bags"] = "Mise aux enchères des objets des sacs"
L["Post Quantity"] = "Quantité de mise en vente"
L["Post Scan"] = "Poster le scan"
L["Post Selected"] = "Enchère sélectionné"
L["Post at Maximum Price"] = "Créer une enchère au prix maximum"
L["Post at Minimum Price"] = "Créer une enchère au prix minimum"
L["Post at Normal Price"] = "Créer une enchère au prix normal"
L["Post cap"] = "Post cap"
L["Post cap to bags"] = "Post cap to bags"
L["Post from Shopping Scan"] = "Créer une enchère à partir de l'analyse d'achat"
L["Postage"] = "Frais d'envoi"
L["Posted at whitelisted player's price."] = "Enchère créée au prix d'un joueur en liste blanche."
L["Posted:"] = "Enchère créée :"
L["Posting"] = "Poster"
L["Posting %d / %d"] = "Poster %d / %d"
L["Posting %d items for %s hours."] = "Poster %d objet pendant %s heures."
L["Posting %d stack(s) of %d for %s hours."] = "Mise aux enchères de %d pile(s) de %d pendant %s heures."
L["Posting Options"] = "Option de mise au enchère"
L["Posting Price"] = "Prix de l'enchère"
L["Posting at normal price."] = "Affichage au prix normal."
L["Posting at whitelisted player's price."] = "Créer une enchère au prix du joueur sur la liste blanche."
L["Posting at your current price."] = "Affichage à votre prix actuel."
L["Posting disabled."] = "Création d’enchère désactivée."
L["Posts"] = "Enchères"
L["Potential"] = "Potentiel"
L["Prepare Bid"] = "Préparer l'offre"
L["Prepare Buy"] = "Préparez l'achat"
L["Preparing..."] = "Préparation..."
L["Prevent closing the Auction House with the esc key"] = "Empêcher la fermeture de l'hôtel des ventes avec la touche Echap"
L["Primary"] = "Primary"
L["Primary Alt"] = "Primary Alt"
L["Prints out the available price sources for use in custom prices"] = "Affiche les sources de prix disponibles à utiliser dans les prix personnalisés"
L["Prints out the version numbers of all installed modules"] = "Affiche les numéros de version de tous les modules installés"
L["Prints the slash command help listing"] = "Afficher la liste d'aide de la commande slash"
L["Profession"] = "Métier"
L["Profession Info"] = "Info du métier"
L["Professions Used In"] = "Métiers utilisés dans"
L["Profile changed to '%s'."] = "Le profil a été remplacé par '%s'."
L["Profiles"] = "Profils"
L["Profit"] = "Bénéfice"
L["Profit (Total)"] = "Bénéfice (Total)"
L["Prospect"] = "Prospect"
L["Prospect Value"] = "Valeur de la prospection"
L["Purchase"] = "Achat"
L["Purchase / Sale Info"] = "Informations d'achat / vente"
L["Purchase Data"] = "Données d'Achat"
L["Purchase Item"] = "Acheter un objet"
L["Purchase information"] = "Informations d'achat"
L["Purchased (Min/Avg/Max Price)"] = "Acheté (Prix Min/Moyen/Max)"
L["Purchased (Total Price)"] = "Acheté (Prix total)"
L["Purchases"] = "Achats"
L["Purchasing Auction"] = "Vente aux enchères"
L["Puts items matching the item or partial text entered into the bank or guild bank."] = "Place les objets correspondant à l'objet ou au texte partiel saisi dans la banque ou la banque de guilde."
L["Qty"] = "Qté"
L["Quantity"] = "Quantité"
L["Quantity Purchased:"] = "Quantité achetée :"
L["Quantity Sold:"] = "Quantité vendue :"
L["Quantity to move"] = "Quantité à déplacer"
L["Quest Added"] = "Quête ajoutée"
L["Quest Completed"] = "Quête terminée"
L["Quest Objectives Complete"] = "Objectifs de quête terminés"
L["Queue"] = "File"
L["Queue (%d)"] = "Queue (%d)"
L["Queue Summary"] = "Queue Summary"
L["Quickly mail all excess disenchantable items to a character"] = "Envoi de tout objet désenchantable au personnage de votre choix"
L["Quickly mail all excess gold (limited to a certain amount) to a character"] = "Envoyez rapidement tout l'or excédentaire (limité à un certain montant) à un personnage"
L["Raid Warning"] = "Alerte de Raid"
L["Rank %d"] = "Rank %d"
L["Read More"] = "Lire la suite"
L["Ready Check"] = "Vérification prête"
L["Ready to Cancel"] = "Prêt à Annuler"
L["Reagent Quality"] = "Reagent Quality"
L["Recent"] = "Récent"
L["Recent Scans"] = "Scans récents"
L["Recent Searches"] = "Recherches récentes"
L["Recent Value"] = "Recent Value"
L["Recent value"] = "Recent value"
L["Recipe Name"] = "Nom de la recette"
L["Recipient"] = "Bénéficiaire"
L["Region Avg Daily Sold"] = "Région - Moy. quotidienne vendue"
L["Region Historical Price"] = "Région - Prix historique"
L["Region Market Value Avg"] = "Région - Valeur moy. du marché"
L["Region Sale Avg"] = "Région - Moy. des ventes"
L["Region Sale Rate"] = "Région - Taux de vente"
L["Region avg daily sold"] = "Région - Moy. quotidienne vendue"
L["Region historical price"] = "Région - Prix historique"
L["Region market value"] = "Région - Valeur du marché"
L["Region market value and trend"] = "Region market value and trend"
L["Region sale avg"] = "Région - Moy. des ventes"
L["Region sale rate"] = "Région - Taux de vente"
L["Reload"] = "Recharger"
L["Reload UI (%02d)"] = "Recharger interface (%02d)"
L["Reload UI (%d)"] = "Recharger interface (%d)"
L["Remove"] = "Retirer"
L["Remove %d |4Item:Items"] = "Retirer %d |4Item:Items"
L["Remove Data Older Than (Days)"] = "Supprimer les données de plus de (jours)"
L["Remove this account sync and all synced data from this account"] = "Supprimer cette synchronisation de compte et toutes les données synchronisées de ce compte"
L["Removed a total of %s old records."] = "Suppression d'un total de %s d'anciens enregistrements."
L["Removed custom price source (%s) which has an invalid name."] = "Source de prix personnalisée supprimée (%s) dont le nom n'est pas valide."
L["Rename"] = "Renommer"
L["Rename Profile"] = "Renommer le profil"
L["Rename Search"] = "Renommer la recherche"
L["Rename the profile"] = "Renommer le profil"
L["Rename this group"] = "Renommer le groupe"
L["Repair"] = "Réparer"
L["Repair Bill"] = "Facture de réparation"
L["Repair from Guild Bank"] = "Réparation avec la banque de guilde"
L["Replace %d existing operations and %d existing custom sources?"] = "Remplacer %d opérations existantes e t%d sources personnalisées existantes?"
L["Replace %d existing operations?"] = "Remplacer %d opérations existantes?"
L["Reply"] = "Répondre"
L["Report Spam"] = "Signaler comme spam"
L["Reports"] = "Rapports"
L["Repost threshold"] = "Seuil de remise en enchère"
L["Required Level"] = "Niveau requis"
L["Required Level Range"] = "Plage de niveau requis"
L["Resale"] = "Revendre"
L["Rescan"] = "Rescan"
L["Reset"] = "Réinitialiser"
L["Reset All Filters"] = "Réinitialiser tout les filtres"
L["Reset Filters"] = "Réinitialiser les filtres"
L["Reset Operation?"] = "Réinitialiser l’opération ?"
L["Reset Profile?"] = "Réinitialiser le profile ?"
L["Reset Table"] = "Réinitialiser le tableau"
L["Reset Zoom"] = "Réinitialiser le zoom"
L["Reset the current profile to default settings"] = "Réinitialiser le profil actuel avec les paramètres par défaut"
L["Reset to Default"] = "Rétablir la valeur par défaut"
L["Resetting the operation will return all inputs back to default and cannot be unddone. Click confirm to reset."] = "La réinitialisation de l'opération ramènera toutes les entrées aux valeurs par défaut et ne pourra pas être annulée. Cliquez sur confirmer pour réinitialiser."
L["Restart"] = "Redémarrer"
L["Restart delay (minutes)"] = "Redémarrer après (minutes)"
L["Restock Groups"] = "Restock Groups"
L["Restock Options"] = "Options de réapprovisionnement"
L["Restock TSM Groups"] = "Restock TSM Groups"
L["Restock bags"] = "Réapprovisionner les sacs"
L["Restock help for %s: %s"] = "Aide de réapprovisionner pour %s : %s"
L["Restock quantity"] = "Quantité de réapprovisionnement"
L["Restock target to max quantity"] = "Réapprovisionner la cible en quantité maximale"
L["Restocking to %d."] = "Réapprovisionnement en %d."
L["Restocking with a min profit."] = "Réapprovisionnement avec un profit min."
L["Restocking with no min profit."] = "Réapprovisionnement sans profit min."
L["Restore bags"] = "Restaurer les sacs"
L["Resuming Scan..."] = "Reprise de l'analyse..."
L["Retail Region-Wide Tracking"] = "Retail Region-Wide Tracking"
L["Retrying %d auction(s) which failed."] = "Nouvelle tentative de %d enchères qui a échoué."
L["Revenue"] = "Revenus"
L["Right-Click to reset the window size, scale, and position to their defaults."] = "Cliquez avec le bouton droit de la souris pour réinitialiser la taille, l'échelle et la position de la fenêtre à leurs valeurs par défaut."
L["Run Advanced Item Search"] = "Lancer la recherche avancée d'objet"
L["Run Bid Sniper"] = "Scan d'OFFRES \"Sniper\""
L["Run Buyout Sniper"] = "Lancer le sniper de rachat"
L["Run Cancel Scan"] = "Exécuter l'analyse d'annulation"
L["Run Post Scan"] = "Exécuter l'analyse des enchères"
L["Run Shopping Scan"] = "Lancer l'analyse des achats"
L["Running Sniper Scan"] = "Scan \"SNIPER\""
L["SALES"] = "VENTES"
L["SCAN ALL"] = "TOUT SCANNER"
L["SCANNING"] = "SCAN EN COURS"
L["SENDING"] = "ENVOI"
L["SHIFT"] = "MAJ"
L["SOURCE %d"] = "SOURCE %d"
L["Sale"] = "Vente"
L["Sale Data"] = "Données de vente"
L["Sale Price"] = "Prix de vente"
L["Sale Rate"] = "Taux de vente"
L["Sale information"] = "Informations sur la vente"
L["Sale rate"] = "Taux de vente"
L["Sales"] = "Ventes"
L["Salvage"] = "Salvage"
L["Save & Close"] = "Save & Close"
L["Saved"] = "Saved"
L["Scan"] = "Analyse"
L["Scan Paused"] = "Analyse Interrompu"
L["Scan complete sound"] = "Son d’analyse complète"
L["Scan was slowed down by %s seconds by other AH addons (%s seconds by %s)."] = "L'analyse a été ralentie de %s secondes par d'autres modules complémentaires D’HV (%s secondes de %s)."
L["Scanning"] = "Analyse"
L["Scanning (%d Items)"] = "Analyse  (%d objets)"
L["Scroll Wheel Options"] = "Options de la molette de défilement"
L["Scroll wheel direction"] = "Direction de la molette de défilement"
L["Search"] = "Recherche"
L["Search %s operations"] = "Rechercher %s opérations"
L["Search Bags"] = "Recherche de sacs"
L["Search Groups"] = "Chercher groupes"
L["Search Operations"] = "Recherche opérations"
L["Search Patterns"] = "Motifs de recherche"
L["Search Results"] = "Résultats de la recherche"
L["Search Vendor"] = "Sélectionner un vendeur"
L["Search items"] = "Rechercher objets"
L["Search items in group"] = "Rechercher les objets dans le groupe"
L["Search items in mailbox"] = "Rechercher des objets dans la boîte aux lettres"
L["Search the auction house"] = "Rechercher dans l'hôtel des ventes"
L["Select / Deselect All Groups"] = "Sélectionner/désélectionner tout les groupes"
L["Select / Deselect All Items"] = "Sélectionner/désélectionner tout les objets"
L["Select / Deselect All Results"] = "Sélectionner/désélectionner tout les résultats"
L["Select Action"] = "Sélectionner une action"
L["Select All"] = "Sélectionner tout"
L["Select Auction to Cancel"] = "Sélectionner une enchère à annuler"
L["Select Crafted Item Quality"] = "Select Crafted Item Quality"
L["Select Group"] = "Sélectionner groupe"
L["Select Items to Attach"] = "Sélectionnez les objets à joindre"
L["Select a Source"] = "Sélectionnez une source"
L["Select an Auction to Buy"] = "Sélectionnez une enchère à acheter"
L["Select crafter"] = "Sélectionnez artisan"
L["Select included subgroups"] = "Sélectionnez les sous-groupes à inclure"
L["Select professions"] = "Sélectionnez des métiers"
L["Selected Items (%d)"] = "Selected Items (%d)"
L["Sell"] = "Vendre"
L["Sell All"] = "Tout vendre"
L["Sell BoEs"] = "Vendre LqR"
L["Sell Groups"] = "Vendre groupes"
L["Sell Options"] = "Options de vente"
L["Sell Trash"] = "Vendre la corbeille"
L["Sell soulbound items"] = "Vendre les objets liés"
L["Sell to Vendor"] = "Vendre au vendeur"
L["Seller"] = "Vendeur"
L["Selling soulbound items."] = "Vendre les objets liés."
L["Send"] = "Envoyer"
L["Send Disenchantables"] = "Envoyer les désenchantables"
L["Send Excess Gold to Banker"] = "Envoyer l'excédent d'or au personnage banquier"
L["Send Gold"] = "Envoyer de l'or"
L["Send Mail"] = "Envoyer courrier"
L["Send Money"] = "Envoyer argent"
L["Send grouped items individually"] = "Envoyer individuellement les objets groupés"
L["Send your active profile to this synced account"] = "Envoyez votre profil actif à ce compte synchronisé"
L["Sender"] = "Expéditeur"
L["Sending %s to %s"] = "Envoi %s à %s"
L["Sending %s to %s with a COD of %s"] = "Envoi de %s à %s en C.R. de %s"
L["Sending Settings"] = "Paramètres d'envoi"
L["Sending your '%s' profile to %s. Please keep both characters online until this completes. This will take approximately: %s"] = "Envoi du profil '%s' à %s. Laissez les deux personnages connectés tant que ce n'est pas terminé. Cela prendra environ : %s"
L["Sending..."] = "Envoi en cours..."
L["Set bid as percentage of buyout"] = "Définir l'enchère en pourcentage du rachat"
L["Set how items are moved out of the bank."] = "Définissez la manière dont les objets sont déplacés hors de la banque."
L["Set how items are restocked from the bank."] = "Définissez le mode de réapprovisionnement des objets auprès de la banque."
L["Set keep in bags quantity"] = "Définir la quantité à laisser dans les sacs"
L["Set keep in bank quantity"] = "Définir la quantité à laisser dans la banque"
L["Set max quantity"] = "Définir la quantité maximale"
L["Set min profit"] = "Définir le profit minimum"
L["Set move quantity"] = "Définir la quantité de mouvement"
L["Set stack size"] = "Fixer la taille de la pile"
L["Set stack size for restock"] = "Définir la taille de la pile pour le réapprovisionnement"
L["Set what is bought from a vendor."] = "Définissez ce qui est acheté auprès d'un fournisseur."
L["Set what is sold to a vendor."] = "Définissez ce qui est vendu à un fournisseur."
L["Set what items are shown during a Shopping scan."] = "Définir les objets affichés lors d'une analyse d'achat"
L["Set what items are shown during a Sniper scan."] = "Définissez les objets affichés lors d'une analyse Sniper."
L["Set your active profile or create a new one."] = "Définissez votre profil actif ou créez-en un nouveau."
L["Settings"] = "Réglages"
L["Setup various sounds that play when doing Auctioning scans."] = "Configurez divers sons qui sont diffusés lors des analyses de Auctioning."
L["Share operations between all profiles"] = "Share operations between all profiles"
L["Shopping"] = "Achats"
L["Shopping %s button"] = "Bouton %s achats"
L["Shopping Operation Max Price"] = "Prix maximum de l'opération d'achat"
L["Shopping for auctions including those above the max price."] = "Acheter des enchères, y compris celles supérieures au prix maximum."
L["Shopping for auctions with a max price set."] = "Acheter pour des enchères avec un prix maximum fixé."
L["Shopping operation"] = "Opération d'achat"
L["Shopping operations control buyout from the AH."] = "Les opérations d'achat contrôlent le rachat de l'HV."
L["Shortfall to bags"] = "Manque de place dans les sacs"
L["Show auctions above max price"] = "Afficher les enchères au-dessus du prix maximum"
L["Show confirmation alert if buyout is above the alert price"] = "Afficher l'alerte de confirmation si le rachat est supérieur au prix d'alerte"
L["Show destroying frame automatically"] = "Afficher automatiquement la fenêtre de destruction"
L["Show on modifier"] = "Afficher sur le modificateur"
L["Show only auctions with bids"] = "Afficher uniquement les enchères avec offres"
L["Show results as:"] = "Show results as:"
L["Show total gold in header"] = "Show total gold in header"
L["Show ungrouped items as:"] = "Show ungrouped items as:"
L["Showing %s Mail"] = "Affichage du courrier %s"
L["Showing %s of %d Mail"] = "Affichage de %s sur %d courrier"
L["Showing %s of %d Mails"] = "Affichage de %s sur %d courriers"
L["Showing all %s Mails"] = "Affichage de tous les %s courriers"
L["Simple convert tooltip"] = "Simple convert tooltip"
L["Simple destroy tooltip"] = "Simple destroy tooltip"
L["Simple inventory"] = "Inventaire simple"
L["Skip"] = "Ignorer"
L["Skipped:"] = "Ignoré :"
L["Skipped: No assigned operation"] = "Passé : Aucune opération assignée"
L["Slash Commands:"] = "Commandes Slash :"
L["Smart Avg Buy Price"] = "Prix d'achat moyen intelligent"
L["Sniper"] = "Sniper"
L["Sniper %s button"] = "Bouton %s Sniper"
L["Sniper Below Price"] = "Sniper en dessous du prix"
L["Sniper Operation Below Price"] = "Opération de Sniper en dessous du prix"
L["Sniper Options"] = "Options du Sniper"
L["Sniper operation"] = "Opération Sniper"
L["Sniper operations control sniping from the AH."] = "Les opérations de Sniper contrôlent les 'sniping' depuis l'HV."
L["Sniping items below a max price"] = "Sniping d'objet en dessous d'un prix maximum"
L["Sold"] = "Vendu"
L["Sold %d of %s to %s for %s"] = "Vendu %d de %s à %s pour %s"
L["Sold %s worth of items."] = "Vendu pour une valeur de %s d'objets."
L["Sold (Min/Avg/Max Price)"] = "Vendu (Prix Min/Moyen/Max)"
L["Sold (Total Price)"] = "Vendu (Prix total)"
L["Sold [%s]x%d for %s to %s"] = "Vendu [%s]x%d pour %s à %s"
L["Sold for:"] = "Vendu pour :"
L["Some general Accounting options are below."] = "Certaines options générales d'Accounting sont présentées ci-dessous."
L["Some general Auctioning options are below."] = "Certaines options générales d'Auctioning sont présentées ci-dessous."
L["Some general Browse/Sniper options are below."] = "Certaines options générales de navigation/Sniper sont disponibles ci-dessous."
L["Some general TSM options are below."] = "Certaines options générales de TSM sont présentées ci-dessous."
L["Some general appearance options are below."] = "Certaines options générale d'apparence sont ci-dessous."
L["Some general options for the TSM tooltip information are below."] = "Certaines options générales pour les informations d'info-bulle de TSM sont présentées ci-dessous."
L["Some options for the Disenchant Search are below."] = "Certaines options pour la recherche de désenchantement sont ci-dessous."
L["Source"] = "Source"
L["Sources"] = "Sources"
L["Sources to include for restock"] = "Sources à inclure pour le réapprovisionnement"
L["Specific Item"] = "Specific Item"
L["Stack"] = "Pile"
L["Stack / Quantity"] = "Pile / Quantité"
L["Stack size"] = "Taille de la pile"
L["Stack size multiple"] = "Taille de pile multiple"
L["Stack(s)"] = "Pile(s)"
L["Start either a 'Buyout' or 'Bid' sniper using the buttons above."] = "Démarrez un sniper de rachat ou d'enchère en utilisant les boutons ci-dessus."
L["Starting Scan..."] = "Début du scan ..."
L["Stormwind"] = "Hurlevent"
L["String"] = "Chaîne"
L["Subject"] = "Sujet"
L["Subject & Description added"] = "Sujet et description ajoutés"
L["Successfully sent your '%s' profile to %s!"] = "Envoi réussi de votre profil  '%s' à %s !"
L["Supported value range: %d - %d"] = "Plage de valeurs prises en charge : %d - %d"
L["Swamp of Sorrows"] = "Marais des Chagrins"
L["Switch to %s"] = "Basculer vers %s"
L["Sync Setup Error: The specified player on the other account is not currently online."] = "Erreur de configuration de la synchronisation: le joueur spécifié sur l'autre compte n'est pas en ligne actuellement."
L["Sync Setup Error: This character is already part of a known account."] = "Erreur de configuration de la synchronisation : ce personnage fait déjà partie d'un compte connu."
L["Sync Setup Error: You entered the name of the current character and not the character on the other account."] = "Erreur de configuration de la synchronisation: vous avez entré le nom du personnage actuel et non le personnage de l'autre compte."
L["Sync Status"] = "État de la synchronisation"
L["TOP PURCHASE"] = "TOP ACHAT"
L["TOP SALE"] = "TOP VENTE"
L["TSM %s: What's new"] = "TSM %s: What's new"
L["TSM Accounting"] = "TSM Accounting"
L["TSM AuctionDB"] = "TSM AuctionDB"
L["TSM Auctioning"] = "TSM Enchères"
L["TSM Crafting"] = "TSM Métier"
L["TSM Desktop App Status (%s)"] = "État de TSM Desktop App (%s)"
L["TSM General Info"] = "Informations générales TSM"
L["TSM Shopping"] = "TSM Achats"
L["TSM Sniper"] = "TSM Sniper"
L["TSM TASK LIST"] = "TSM LISTE DE TACHES"
L["TSM Version Info:"] = "Version de TSM :"
L["TSM can automatically sync data between multiple WoW accounts."] = "TSM peut synchroniser automatiquement les données entre plusieurs comptes WoW."
L["TSM detected that you just traded %s to %s in return for %s. Would you like Accounting to store a record of this trade?"] = "TSM detected that you just traded %s to %s in return for %s. Would you like Accounting to store a record of this trade?"
L["TSM doesn't currently have any AuctionDB pricing data for your realm. We recommend you download the TSM Desktop Application from %s to automatically update your AuctionDB data (and auto-backup your TSM settings)."] = "TSM ne dispose actuellement d'aucune donnée sur les prix de AuctionDB pour votre royaume. Nous vous recommandons de télécharger l'application TSM Desktop à partir de %s pour mettre à jour automatiquement vos données AuctionDB (et sauvegarder automatiquement vos paramètres TSM)."
L["TSM failed to scan some auctions. Please rerun the scan."] = "TSM a échoué à scanner quelques ventes. Veuillez relancer le scan."
L["TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."] = "TSM is currently rebuilding its item cache which may cause FPS drops and result in TSM not being fully functional until this process is complete. This is normal and typically takes a few minutes."
L["TSM is missing important information from the TSM Desktop Application. Please ensure the TSM Desktop Application is running and is properly configured."] = "TSM ne parvient pas à accéder à d'importantes informations de l'application TSM Desktop. Assurez-vous s'il vous plaît que TSM Desktop fonctionne et soit correctement configuré."
L["TSM is not yet ready to establish a new sync connection. Please try again later."] = "TSM n'est pas encore prêt à établir une nouvelle connexion de synchronisation. Veuillez réessayer plus tard."
L["TSM will not undercut any players you add to your whitelist."] = "TSM ne sous-enchérira pas sur les joueurs de votre liste blanche."
L["TSM4"] = "TSM4"
L["Target character"] = "Personnage cible"
L["Target shortfall to bags"] = "Cibler le manque à gagner dans les sacs"
L["Tasks Added to Task List"] = "Tâches ajoutées à la liste des tâches"
L["Tells you why a specific item is not being restocked and added to the queue."] = "Vous indique pourquoi un objet spécifique n'est pas réapprovisionné et ajouté à la file d'attente."
L["Text (%s)"] = "Texte (%s)"
L["The '%s' function has an invalid number of arguments."] = "The '%s' function has an invalid number of arguments."
L["The '%s' item parameter was used outside of a custom source."] = "The '%s' item parameter was used outside of a custom source."
L["The 'Craft Value Method' did not return a value for this item."] = "La 'méthode de la valeur artisanale' n'a renvoyé aucune valeur pour cet objet."
L["The 'use smart average for purchase price' setting has been removed from TSM and replaced with a new 'SmartAvgBuy' price source. Please update your custom prices appropriately."] = "Le paramètre «Utiliser la moyenne intelligente pour le prix d'achat» a été supprimé de TSM et remplacé par une nouvelle source de prix «SmartAvgBuy». Veuillez mettre à jour vos prix personnalisés de manière appropriée."
L["The AH does not support specifying a copper value (only gold and silver)."] = "The AH does not support specifying a copper value (only gold and silver)."
L["The Base Group contains all ungrouped items in the game. Use the search and filter controls to find items to add to other groups."] = "Le groupe de base contient tous les objet non groupés du jeu. Utilisez les commandes de recherche et de filtrage pour trouver des objet à ajouter à d'autres groupes."
L["The TradeSkillMaster_AppHelper addon is installed, but not enabled. TSM has enabled it and requires a reload."] = "L'add-on TradeSkillMaster_AppHelper est installé, mais non activé. TSM l'a activé de lui-même, mais le rechargement de l'interface est requis."
L["The buyout price for %s would be above the maximum allowed price. Skipping this item."] = "Le prix de rachat de %s serait supérieur au prix maximum autorisé. Ignorer cet objet."
L["The canlearn filter was ignored because the CanIMogIt addon was not found."] = "Le filtre 'canlearn' a été ignoré car le module complémentaire 'CanIMogIt' n'a pas été trouvé."
L["The max quantity cannot be zero."] = "La quantité maximale ne peut pas être nulle."
L["The min profit did not evaluate to a valid value for this item."] = "The min profit did not evaluate to a valid value for this item."
L["The name portion of the search term must be at least 3 characters if present."] = "La partie nom du terme de recherche doit comporter au moins 3 caractères si elle est présente."
L["The pasted value was not valid. Ensure you are pasting the entire import string."] = "La valeur collée n'était pas valide. Assurez-vous de coller l'intégralité de la chaîne d'importation."
L["The player \\\"%s\\\" is already on your whitelist."] = "The player \\\"%s\\\" is already on your whitelist."
L["The price must contain g/s/c labels. For example '1g 2s' means 1 gold and 2 silver."] = "The price must contain g/s/c labels. For example '1g 2s' means 1 gold and 2 silver."
L["The profit of this item (%s) is below the min profit (%s)."] = "Le bénéfice de cet objet (%s) est inférieur au bénéfice minimum (%s)."
L["The same filter was specified multiple times."] = "Le même filtre a été spécifié plusieurs fois."
L["The search term must be at least 3 characters."] = "Le terme de recherche doit comporter au moins 3 caractères."
L["The seller name of the lowest auction for %s was not given by the server. Skipping this item."] = "Le nom du vendeur de l'enchère la plus basse pour %s n'a pas été indiqué par le serveur. Ignorer cet objet."
L["The specified filter was empty."] = "Le filtre spécifié était vide."
L["The specified item is not supported for crafting searches."] = "L'objet spécifié n'est pas pris en charge pour les recherches d'artisanat."
L["The specified item is not supported for disenchant searches."] = "L'objet spécifié n'est pas pris en charge pour les recherches de désenchantement."
L["The specified item was not found."] = "L'objet spécifié est introuvable."
L["The unlearned filter was ignored because the CanIMogIt addon was not found."] = "Le filtre 'unlearned ' a été ignoré car le module complémentaire CanIMogIt n'a pas été trouvé."
L["The value must be greater than 0."] = "The value must be greater than 0."
L["The value must be greater than or equal of 0."] = "The value must be greater than or equal of 0."
L["The value was greater than the maximum allowed auction house price."] = "The value was greater than the maximum allowed auction house price."
L["Themes"] = "Thèmes"
L["There are unbalanced parentheses in this custom string."] = "There are unbalanced parentheses in this custom string."
L["There is currently no profession open, so cannot create profession groups."] = "Il n'y a actuellement aucun métier ouverte, il est donc impossible de créer des groupes de métier."
L["There is no Crafting operation applied to this item's TSM group (%s)."] = "Aucune opération de fabrication n'est appliquée au groupe TSM de cet objet (%s)."
L["This custom string is too complex for WoW to handle; use custom sources to simplify it."] = "This custom string is too complex for WoW to handle; use custom sources to simplify it."
L["This is not a valid profile name. Profile names must be at least one character long and may not contain '@' characters."] = "Ce n'est pas un nom de profil valide. Les noms de profil doivent comporter au moins un caractère et ne doivent pas contenir de caractères «@»."
L["This item does not have a crafting cost. Check that all of its mats have mat prices."] = "Cet objet n'a pas de coût de fabrication. Vérifiez que tous ses composant ont des prix de composant."
L["This item is not in a TSM group."] = "Cet objet n'est pas dans un groupe TSM."
L["This item will be added to the queue when you restock its group. If this isn't happening, please visit http://support.tradeskillmaster.com for further assistance."] = "Cet objet sera ajouté à la file d'attente lorsque vous réapprovisionnerez son groupe. Si cela ne se produit pas, veuillez visiter http://support.tradeskillmaster.com pour obtenir de l'aide."
L["This operation is applied to the base group which includes every item not in another group."] = "Cette opération est appliquée au groupe de base qui comprend tous les éléments n'appartenant pas à un autre groupe."
L["This price is above your confirmation alert threshold."] = "Ce prix est supérieur à votre seuil d'alerte de confirmation."
L["This price is above your material value."] = "This price is above your material value."
L["This profession is not open."] = "Le métier n’est pas ouvert"
L["This record belongs to another account and can only be deleted on that account."] = "Cet enregistrement appartient à un autre compte et ne peut être supprimé que sur ce compte."
L["This will permanently delete the '%s' profile."] = "Cela supprimera définitivement le profil '%s'."
L["This will reset all groups and operations (if not stored globally) to be wiped from '%s'."] = "Cela réinitialisera tous les groupes et opérations (s'ils ne sont pas stockés globalement) à effacer de '%s'."
L["Time"] = "Temps"
L["Time Frame"] = "Il y a"
L["Tinker"] = "Ambulant"
L["Toggles the TSM Banking UI if either the bank or guild bank is currently open."] = "Active / désactive l'interface utilisateur TSM Banque si la banque ou la banque de guilde est actuellement ouverte."
L["Toggles the TSM Crafting UI."] = "Active / désactive l'interface utilisateur TSM Métier."
L["Toggles the TSM Task List UI"] = "Active / désactive l'IU de la liste des tâches TSM"
L["Toggles the main TSM window"] = "Active / désactive la fenêtre principale TSM"
L["Tooltip Options"] = "Options d'info-bulle"
L["Tooltip Settings"] = "Paramètre de l'info-bulle"
L["Tooltip price format"] = "Format de prix de l'info-bulle"
L["Top Buyers"] = "Top acheteurs"
L["Top Item"] = "Top des objets"
L["Top Sellers"] = "Meilleures ventes"
L["Total"] = "Total"
L["Total Gold"] = "Or total"
L["Total Gold Collected: %s"] = "Or total collectées : %s"
L["Total Gold Earned"] = "Total d'or gagné"
L["Total Gold Spent"] = "Total d'or dépensé"
L["Total Inventory Quantity"] = "Quantité totale d'inventaire"
L["Total Items"] = "Objet  au total"
L["Total Postage"] = "Frais d'envoi"
L["Total Price"] = "Prix total"
L["Total Prices:"] = "Prix totaux :"
L["Total Profit"] = "Bénéfice total"
L["Total Value"] = "Valeur totale"
L["Track Sales / Purchases via trade"] = "Suivre les ventes / achats via le commerce"
L["Transform"] = "Transform"
L["Transform Value"] = "Valeur de transformation"
L["Type"] = "Type"
L["Uncollected Only"] = "Non collecté uniquement"
L["Undercut amount"] = "Pas de sous-enchère"
L["Undercut by whitelisted player."] = "Sous-enchère par un joueur en liste blanche."
L["Undercutting blacklisted player."] = "Sous-enchère par un joueur en liste noire."
L["Undercutting competition."] = "Sous-enchérir."
L["Unexpected word ('%s') in custom string."] = "Unexpected word ('%s') in custom string."
L["Ungrouped Items"] = "Objets non-groupés"
L["Ungrouped Items in Bags"] = "Articles non groupés dans les sacs"
L["Unit Price"] = "Prix unitaire"
L["Unknown Item"] = "Objet inconnu"
L["Unknown word (%s)."] = "Mots inconnus (%s)"
L["Unlock Column Width"] = "Déverrouiller la largeur de la colonne"
L["Unwrap Gift"] = "Déballer le cadeau"
L["Up"] = "Haut"
L["Up to date"] = "À jour"
L["Update existing macro"] = "Mettre à jour la macro existante"
L["Updating"] = "Mise à jour"
L["Upgrades Only"] = "Amélioration uniquement"
L["Usable Only"] = "Utilisable uniquement"
L["Usage: /tsm price <Item Link> <Custom String>"] = "Utilisation : /tsm price <liens d'objet> <Chaîne personnalisée>"
L["Use the settings below to control which lines are shown in tooltips."] = "Utilisez les paramètres ci-dessous pour contrôler les lignes affichées dans les info-bulles."
L["Use this list to manage what cooldowns you'd like TSM to ignore from crafting."] = "Utilisez cette liste pour gérer les temps de recharge que vous souhaitez que TSM ignore lors de la fabrication."
L["Use this list to manage what items you'd like TSM to ignore from destroying."] = "Utilisez cette liste pour gérer les objets que vous souhaitez que TSM ignore lors de la destruction."
L["Value"] = "Valeur"
L["Value Price Source"] = "Source de prix de valeur"
L["Value must be between %d and %d."] = "La valeur doit être comprise entre %d et %d."
L["Values"] = "Valeurs"
L["Vendor"] = "Marchand"
L["Vendor Buy Price"] = "Prix d'achat au marchand"
L["Vendor Search"] = "Recherche de vendeurs"
L["Vendor Sell"] = "Vendre au marchant"
L["Vendor Sell Price"] = "Prix de vente au marchand"
L["Vendor Trade"] = "Vendor Trade"
L["Vendor Trade Value"] = "Vendor Trade Value"
L["Vendor buy price"] = "Prix d'achat au marchand"
L["Vendor sell price"] = "Prix de vente au marchand"
L["Vendoring"] = "Vente"
L["Vendoring %s button"] = "Bouton %s de vente"
L["Vendoring operation"] = "Opération de vente"
L["Vendoring operations control selling to and buying from a vendor."] = "Les opérations de vente contrôlent la vente et l'achat d'un marchand."
L["WARNING: The macro was too long, so was truncated to fit by WoW."] = "ATTENTION : La macro est trop longue, elle a donc été tronquée par défaut par WoW."
L["WARNING: Your minimum price for %s is below its vendorsell price (with AH cut taken into account). Consider raising your minimum price, or vendoring the item."] = "AVERTISSEMENT : votre prix minimum pour %s est inférieur à son prix de vente (avec la réduction HV prise en compte). Envisagez d'augmenter votre prix minimum ou de vendre l'article."
L["WOW UI"] = "interface WoW"
L["Warehousing"] = "Entreposage"
L["Warehousing operation"] = "Opération d'entreposage"
L["Warehousing operations control moving in and out of the bank."] = "Les opérations d'entreposage contrôlent l'entrée et la sortie des banques."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "L'entreposage déplacera au maximum %d de chaque objet de ce groupe en gardant %d de chaque objet lorsque sacs > banque/banque de guilde, %d de chaque objet lorsque banque/banque de guilde > sacs."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "L'entreposage déplacera au maximum %d de chaque objet de ce groupe en gardant %d de chaque objet lorsque sacs > banque / banque de guilde,%d de chaque objet lorsque banque / banque de guilde > sacs. le réapprovisionner conservera %d objet dans vos sacs."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank."] = "L'entreposage déplacera au maximum %d de chaque objet de ce groupe en conservant %d de chaque objet lorsque les sacs > banque/banque de guilde."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "L'entreposage déplacera au maximum %d de chaque objet de ce groupe en conservant %d de chaque article lorsque les sacs > banque / banque de guilde. L'entreposage conservera %d objets dans vos sacs."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags."] = "L'entreposage déplacera au maximum  %d de chaque objet de ce groupe en conservant %d de chaque objet lorsque la banque/banque de guilde > sacs."
L["Warehousing will move a max of %d of each item in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "L'entreposage déplacera au maximum %d de chaque objet de ce groupe en conservant %d de chaque objet lorsque la banque / banque de guilde > sacs. L'entreposage conservera %d objet dans vos sacs."
L["Warehousing will move a max of %d of each item in this group."] = "L'entreposage déplacera au maximum %d de chaque objet de ce groupe."
L["Warehousing will move a max of %d of each item in this group. Restock will maintain %d items in your bags."] = "L'entreposage déplacera au maximum %d de chaque objet de ce groupe. Le réapprovisionnement conservera %d objet dans vos sacs."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags."] = "L'entreposage déplacera tous les objets de ce groupe en conservant %d de chaque objet lorsque sacs > banque / banque de guilde, %d de chaque objet lorsque banque / banque de guilde > sacs."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank, %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "L'entreposage déplacera tous les objets de ce groupe en conservant %d de chaque objet lorsque sacs > banque / banque de guilde, %d de chaque objet lorsque banque / banque de guilde > sacs. Le réapprovisionnement  conservera %d objets dans vos sacs."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank."] = "L'entreposage déplacera tous les objets de ce groupe en conservant %d de chaque objet lorsque sacs > banque / banque de guilde."
L["Warehousing will move all of the items in this group keeping %d of each item back when bags > bank/gbank. Restock will maintain %d items in your bags."] = "L'entreposage déplacera tous les objets de ce groupe en conservant %d de chaque objet lorsque sacs>  banque / banque de guilde. le réapprovisionnement conservera %d objets dans vos sacs."
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags."] = "L'entreposage déplacera tous les objets de ce groupe en conservant %d de chaque objet lorsque banque/banque de guilde > sacs."
L["Warehousing will move all of the items in this group keeping %d of each item back when bank/gbank > bags. Restock will maintain %d items in your bags."] = "L'entreposage permettra de déplacer tous les objets de ce groupe en conservant %d de chaque objet lorsque banque/banque de guilde > sacs. Le réapprovisionnement conservera %d objet dans vos sacs."
L["Warehousing will move all of the items in this group."] = "L'entreposage permettra de déplacer tous les articles de ce groupe."
L["Warehousing will move all of the items in this group. Restock will maintain %d items in your bags."] = "L'entreposage permettra de déplacer tous les articles de ce groupe. Restock conservera les articles de %d dans vos sacs."
L["When above maximum:"] = "Lorsqu'au-dessus du maximum :"
L["When below minimum:"] = "Lorsqu'en-dessous du minimum :"
L["Whitelist"] = "Liste blanche"
L["Whitelisted characters"] = "Personnage sur liste blanche"
L["Winamp"] = "Winamp"
L["Would send %s to %s"] = "Souhaiterait envoyer %s à %s"
L["Would send %s to %s with a COD of %s"] = "Envoie %s à %s avec un C.R. de %s"
L["Yes, I'm sure"] = "Yes, I'm sure"
L["Yes, I'm sure (%02d)"] = "Yes, I'm sure (%02d)"
L["You are not on one of the listed characters."] = "Vous n'êtes pas sur l'un des personnages répertoriés."
L["You can clear old Accounting data for the current realm below to keep things running smoothly."] = "You can clear old Accounting data for the current realm below to keep things running smoothly."
L["You can import custom themes by pasting an import string into the box below."] = "You can import custom themes by pasting an import string into the box below."
L["You can import groups by pasting an import string into the box below. Group import strings can be found at: https://tradeskillmaster.com/group-maker/all"] = "Vous pouvez importer des groupes en collant une chaîne d'importation dans la zone ci-dessous. Les chaînes d'importation de groupe peuvent être trouvées sur : https://tradeskillmaster.com/group-maker/all"
L["You can now group pets by level, just like items."] = "You can now group pets by level, just like items."
L["You can use the export string below to share this custom theme with others."] = "You can use the export string below to share this custom theme with others."
L["You can use the export string below to share this group with others."] = "Vous pouvez utiliser la chaîne d'exportation ci-dessous pour partager ce groupe avec d'autres."
L["You cannot use %s as part of this custom price."] = "Vous ne pouvez pas utiliser %s comme prix spécifique."
L["You do not need to add \\\"%s\\\", alts are whitelisted automatically."] = "You do not need to add \\\"%s\\\", alts are whitelisted automatically."
L["You don't know how to craft this item."] = "Vous ne savez pas fabriquer cet objet."
L["You either already have at least your max restock quantity of this item or the number which would be queued is less than the min restock quantity."] = "Soit vous avez déjà au moins votre quantité maximale de réapprovisionnement de cet objet, soit le nombre qui serait mis en file d'attente est inférieur à la quantité minimale de réapprovisionnement."
L["You must reload your UI for these settings to take effect. Reload now?"] = "Vous devez recharger votre UI pour que ces paramètres soient pris en compte. Recharger maintenant ?"
L["You won an auction for %sx%d for %s"] = "Vous avez gagné une enchère de %sx%d pour %s"
L["You've been phased which has caused the AH to stop working due to a bug on Blizzard's end. Please close and reopen the AH and restart Sniper."] = "Vous avez été mis en phase, ce qui a amené l'HV à cesser de fonctionner en raison d'un bug sur le layering de Blizzard. Veuillez fermer et rouvrir HV, puis redémarrer Sniper."
L["You've been undercut."] = "Sous-enchère constatée. (Undercut)"
L["Your Buyout"] = "Votre rachat"
L["Your auction has not been undercut."] = "Votre affichage est le meilleur. (Not Undercut)"
L["Your auction of %s expired"] = "Votre enchère de %s est expirée."
L["Your auction of %s has sold for %s!"] = "Votre enchère %s a été vendue pour %s !"
L["Your auction of %s has sold!"] = "Your auction of %s has sold!"
L["Your craft value method for '%s' was invalid so it has been returned to the default. Details: %s"] = "Votre méthode de valeur de l'artisanat pour les '%s' n'était pas valide, elle est donc revenue à la valeur par défaut. Détails : %s"
L["Your default craft value method was invalid so it has been returned to the default. Details: %s"] = "Votre méthode de valeur par défaut de l'artisanat n'était pas valide, elle est donc revenue à la valeur par défaut. Détails : %s"
L["Your max restock (%s) is invalid for %s."] = "Votre réapprovisionnement maximal (%s) n'est pas valide pour %s."
L["Your min restock (%s) is invalid for %s."] = "Votre réapprovisionnement minimal (%s)  n'est pas valide pour %s."
L["Your restock quantity is invalid. It must be between %d and %s."] = "Votre quantité de réapprovisionnement n'est pas valide. Il doit être compris entre %d et %s."
L["Your task list is currently empty."] = "Votre liste de tâche est actuellement vide."
L["ilvl"] = "ilvl"
-- LOCALE STRINGS END HERE

Locale.SetTable(L)
